var topDownView;
var rooftopMessage = "6\" added all around ladder for the rubber feet";
var crossoverMessage = "FOR ADDED STABILITY OUTRIGGERS HAVE BEEN ADDED \n(ADD 29\" ON EACH SIDE OF 90\xB0 LADDERS)";
function TopDownMPASView(printView) {
  console.clear();
  if (!printView)
    printView = false;

  topDownView = new createjs.Container();
  topDownViewParts = new createjs.Container();

  var topDownBackgroundShape = new createjs.Shape();
  if (printView)
    topDownBackgroundShape.graphics.beginFill("rgba(40,40,40,1)").drawRect(0, 0, 1080, 1600);
  else
    topDownBackgroundShape.graphics.beginFill("rgba(40,40,40,0.75").drawRect(0, 0, 1080, 1600);
  topDownView.addChild(topDownBackgroundShape);

  var topDownBackgroundShapeButtonHelper = new createjs.ButtonHelper(topDownBackgroundShape);
  topDownBackgroundShape.addEventListener("click", backgroundClicked);

  //The Grid
  for (var x = 0; x <= 1080; x += 9) {
    var line = new createjs.Shape();
    line.graphics.beginStroke("rgba(255,255,255,0.2)");
    line.graphics.moveTo(x, 0);
    line.graphics.lineTo(x, 1600);
    topDownViewParts.addChild(line);
  }
  for (var y = 0; y <= 1600; y += 9) {
    var line = new createjs.Shape();
    line.graphics.beginStroke("rgba(255,255,255,0.2)");
    line.graphics.moveTo(0, y);
    line.graphics.lineTo(1080, y);
    topDownViewParts.addChild(line);
  }
  topDownView.addChild(topDownViewParts);

  //Key
  var keyText = new createjs.Text("KEY", "16px sans-serif", "#FFFFFF");
  keyText.textAlign = "center";
  keyText.x = 880;
  keyText.y = 10;
  topDownView.addChild(keyText);

  var ladderShape = new createjs.Shape();
  ladderShape.x = 790;
  ladderShape.y = 30;
  ladderShape.graphics.beginFill("rgba(255,192,0,0.75)").beginStroke("#000000").drawRect(0,0,15,15);
  topDownView.addChild(ladderShape);

  var ladderText = new createjs.Text("LADDER", "16px sans-serif", "#FFFFFF");
  ladderText.textAlign = "left";
  ladderText.y = 30;
  ladderText.x = 815;
  topDownView.addChild(ladderText);

  var spanShape = new createjs.Shape();
  spanShape.x = 790;
  spanShape.y = 50;
  spanShape.graphics.beginFill("rgba(192,192,192,0.75)").beginStroke("#000000").drawRect(0,0,15,15);
  topDownView.addChild(spanShape);

  var spanText = new createjs.Text("BRIDGE SPAN", "16px sans-serif", "#FFFFFF");
  spanText.textAlign = "left";
  spanText.y = 50;
  spanText.x = 815;
  topDownView.addChild(spanText);

  var turnShape = new createjs.Shape();
  turnShape.x = 790;
  turnShape.y = 70;
  turnShape.graphics.beginFill("rgba(64,192,255,0.75)").beginStroke("#000000").drawRect(0,0,15,15);
  topDownView.addChild(turnShape);

  var turnText = new createjs.Text("TURN PLATFORM", "16px sans-serif", "#FFFFFF");
  turnText.textAlign = "left";
  turnText.y = 70;
  turnText.x = 815;
  topDownView.addChild(turnText);

  var turnShapeLadder = new createjs.Shape();
  turnShapeLadder.x = 790;
  turnShapeLadder.y = 90;
  turnShapeLadder.graphics.beginFill("rgb(255, 102, 163,0.75)").beginStroke("#000000").drawRect(0,0,15,15);
  topDownView.addChild(turnShapeLadder);

  var turnLadderText = new createjs.Text("TURN LADDER", "16px sans-serif", "#FFFFFF");
  turnLadderText.textAlign = "left";
  turnLadderText.y = 90;
  turnLadderText.x = 815;
  topDownView.addChild(turnLadderText);


  var totalSpanShape = new createjs.Shape();
  totalSpanShape.graphics.beginStroke("#FFFFFF").setStrokeStyle(2,2);
  totalSpanShape.graphics.moveTo(797, 110);
  totalSpanShape.graphics.lineTo(797, 125);
  topDownView.addChild(totalSpanShape);

  var totalSpanText = new createjs.Text("WIDTH", "16px sans-serif", "#FFFFFF");
  totalSpanText.y = 110;
  totalSpanText.x = 815;
  topDownView.addChild(totalSpanText);

  var openSpanShape = new createjs.Shape();
  openSpanShape.graphics.beginStroke("#00FF00").setStrokeStyle(2,2);
  openSpanShape.graphics.moveTo(797, 130);
  openSpanShape.graphics.lineTo(797, 145);
  topDownView.addChild(openSpanShape);

  var openSpanText = new createjs.Text("LENGTH", "16px sans-serif", "#FFFFFF");
  openSpanText.y = 130;
  openSpanText.x = 815;
  topDownView.addChild(openSpanText);

  var legsShape = new createjs.Shape();
  legsShape.graphics.beginStroke("#FF2020").setStrokeStyle(2,2);
  legsShape.graphics.moveTo(797, 150);
  legsShape.graphics.lineTo(797, 165);
  topDownView.addChild(legsShape);

  var legsText = new createjs.Text("LEG KIT", "16px sans-serif", "#FFFFFF");
  legsText.y = 150;
  legsText.x = 815;
  topDownView.addChild(legsText);

  if (!printView) {
    var instructionText = new createjs.Text("Click Anywhere to Close", "16px sans-serif", "#FFFFFF");
    instructionText.textAlign = "center";
    instructionText.x = 480;
    instructionText.y = 760;
    topDownView.addChild(instructionText);
  }

  var scaleText = new createjs.Text("Each grid line represents 1\'", "16px sans-serif", "#FFFFFF");
  scaleText.textAlign = "left";
  scaleText.x = 10;
  scaleText.y = 10;
  topDownView.addChild(scaleText);

  var point = new createjs.Point(450, 405);
  var direction = 0;
  defaultPartsOrder();
  var lastPart;
  var lastContainer;
  var openSpan = 0;
  var openSpanComponents = new Array();
  var length = 0;
  let width = 0;
  var startPoint = point;
  var directionChange = false;
  let minXY = { minX: startPoint.x, maxX: startPoint.x, minY: startPoint.y, maxY: startPoint.y }
  let i = 0;
  for (let parts of partsContainer.children) {

    let data = parts.partData;
    let parent = parts.parentPart;

    if (data.rails) {
      continue;
    }
    let color = "rgba(192,192,192,0.75)", lengthPart = data.length, widthPart = data.width;
    let rotationType = "default";
    let parentRotationType = "default";
    rotationType = rotationTopDown(parts);
    parentRotationType = rotationTopDown(parent);
    parentConnector =  getConnector(parent?.partData?.length ?? 0,parentRotationType,parts.parentConnector, parent?.partData?.bridgeSpan ?? false);
    let rectanglePoint = [
      new createjs.Point(startPoint.x, startPoint.y),
      new createjs.Point(startPoint.x - widthPart, startPoint.y),
      new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
      new createjs.Point(startPoint.x, startPoint.y - lengthPart)
    ];
    if (data.ladder) {
      color = "rgba(255,192,0,0.75)";
      if (lengthPart < 0) {
        lengthPart = -lengthPart;
      }
    }
    if (!parts.noParent) {

      let isSameRotate = rotationType == parentRotationType;

      if (isSameRotate) {
        directionChange = false;
        switch (true) {
          case data.ladder && parent.partData.bridgeSpan:
            if (rotationType == "default") {
              
                startPoint = new createjs.Point(startPoint.x - .5, startPoint.y );
              
              
            } else {
              startPoint = new createjs.Point(startPoint.x, startPoint.y  - .5);
            }
            break;
          case data.bridgeSpan && parent.partData.ladder:
            if (rotationType == "default") {
              
                startPoint = new createjs.Point(startPoint.x+ .5, startPoint.y );
              
            } else {
              startPoint = new createjs.Point(startPoint.x , startPoint.y- .5);
            }
        }
      }
      else {
        directionChange = true;
        switch (true) {
          case parentConnector == 0:
            if (rotationType == "default") {
              direction = 0;
            }
            else {
              direction = 1;
            }
            break;
          case [1, 4, 5, 6].includes(parentConnector):
            if (rotationType == "default") {
              direction = 1;
            } else {
              direction = 2;
            }
            break;
          case [3, 7, 8, 9].includes(parentConnector):
            if (rotationType == "default") {
              direction = 3;
            } else {
              direction = 0;
            }
            break;
          case parentConnector == 2:
            if (rotationType == "default") {
              direction = 2;
            }
            else {
              direction = 3;
            }
            break;
        }
        if (data.bridgeSpan) {
          color = "rgba(64,192,255,0.75)";
        }
        else {
          color = "rgb(255, 102, 163,0.75)";
        }
      }
      if (data.bridgeSpan && [3, 4, 5, 6,].includes(data?.rotationType ?? 0)) {
        let type = data.rotationType;
        if (
          ([1, 0, 4, 5, 6,3,7,8,9].includes(parentConnector) && rotationType == "default")
          ||([2].includes(parentConnector) && rotationType == "rotate" && data.length == 120 && !parent.noParent)
          ||( parentConnector == 2 && [90,60].includes(parseInt(data.length)) && rotationType == "default")
          ||( parentConnector == 2 && parseInt(data.length) == 120 && rotationType == "default" && parent.partData.ladder)
        ) {

          switch (parseInt(data.rotationType)) {
            case 6:
              type = 3;
              break;
            case 3:
              type = 6;
              break;
            case 4:
              if(data.length !=90)
              type = 5;
              break;
            case 5:
              type = 4;
              break;
          }
        }
        let yAdd = movePlatform({ rotationType: type, length: data.length });
        if (rotationType == "rotate") {

          if ([2,1, 4, 5, 6].includes(parentConnector) && !parent.noParent) {
            startPoint = new createjs.Point(startPoint.x - yAdd, startPoint.y);
          }
          else {
            startPoint = new createjs.Point(startPoint.x + yAdd, startPoint.y);
          }
        } else {
          if(
            [2,3,7,8,9].includes(parentConnector)  
          )
          {
            console.log('ddd', yAdd, data.rotationType)
            startPoint = new createjs.Point(startPoint.x, startPoint.y - yAdd);
          }
          else{  
            startPoint = new createjs.Point(startPoint.x, startPoint.y + yAdd);
          }
        }
      }
      if (rotationType == "rotate") {
        widthPart = (data.length<0)? -data.length : data.length
        lengthPart = data.width;
      }
      console.log("startPoint", startPoint, parentRotationType, parentConnector, direction)
      if (parentRotationType == "default") {
        switch (parseInt(parentConnector ?? 0)) {
          case 0:
            rectanglePoint = [
              new createjs.Point(startPoint.x, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
              new createjs.Point(startPoint.x, startPoint.y - lengthPart)
            ]
            break;
          case 1:
            startPoint = new createjs.Point(startPoint.x - parent.partData.width, startPoint.y + 30);

            rectanglePoint = [
              new createjs.Point(startPoint.x, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
              new createjs.Point(startPoint.x, startPoint.y - lengthPart)
            ]


            break;
          case 4:
            startPoint = new createjs.Point(startPoint.x - parent.partData.width, startPoint.y + 60);
            rectanglePoint = [
              new createjs.Point(startPoint.x, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
              new createjs.Point(startPoint.x, startPoint.y - lengthPart)
            ]
            break;
          case 5:
            startPoint = new createjs.Point(startPoint.x - parent.partData.width, startPoint.y + 90);
            rectanglePoint = [
              new createjs.Point(startPoint.x, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
              new createjs.Point(startPoint.x, startPoint.y - lengthPart)
            ]
            break;
          case 6:
            startPoint = new createjs.Point(startPoint.x - parent.partData.width, startPoint.y + 120);
            rectanglePoint = [
              new createjs.Point(startPoint.x, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
              new createjs.Point(startPoint.x, startPoint.y - lengthPart)
            ]
            break;
          case 3:
            startPoint = new createjs.Point(startPoint.x, startPoint.y);
            rectanglePoint = [
              new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
              new createjs.Point(startPoint.x, startPoint.y + lengthPart),
              new createjs.Point(startPoint.x, startPoint.y),
              new createjs.Point(startPoint.x + widthPart, startPoint.y)
            ]
            break;
          case 7:
            startPoint = new createjs.Point(startPoint.x, startPoint.y + 30);
            rectanglePoint = [
              new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
              new createjs.Point(startPoint.x, startPoint.y + lengthPart),
              new createjs.Point(startPoint.x, startPoint.y),
              new createjs.Point(startPoint.x + widthPart, startPoint.y)
            ]
            break;
          case 8:
            startPoint = new createjs.Point(startPoint.x, startPoint.y + 60);
            rectanglePoint = [
              new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
              new createjs.Point(startPoint.x, startPoint.y + lengthPart),
              new createjs.Point(startPoint.x, startPoint.y),
              new createjs.Point(startPoint.x + widthPart, startPoint.y)
            ]
            break;
          case 9:
            startPoint = new createjs.Point(startPoint.x, startPoint.y + 90);
            rectanglePoint = [
              new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
              new createjs.Point(startPoint.x, startPoint.y + lengthPart),
              new createjs.Point(startPoint.x, startPoint.y),
              new createjs.Point(startPoint.x + widthPart, startPoint.y)
            ]
            break;
          case 2:

            if (parent.partData.bridgeSpan) {
              
              startPoint = new createjs.Point(startPoint.x - parent.partData.width, startPoint.y + parseInt(parent.partData.length));
              rectanglePoint = [
                
                new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x + widthPart, startPoint.y),
               
                
               
              ]
            } else {
              if(parent.noParent)// for first ladder
              {
                rectanglePoint = [
                  new createjs.Point(startPoint.x, startPoint.y),
                  new createjs.Point(startPoint.x - widthPart, startPoint.y),
                  new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
                  new createjs.Point(startPoint.x, startPoint.y - lengthPart)
                ]
              }
              else{
                let parentLength = (parent.partData.length<0)?-(parent.partData.length) : parent.partData.length;
                startPoint = new createjs.Point(startPoint.x - parent.partData.width, startPoint.y + parseInt(parentLength));
                rectanglePoint = [
                  new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x + widthPart, startPoint.y),
                ]
              }
            }
            break;
        }
      }
      else {
        switch (parseInt(parentConnector)) {
          case 0:
            if (rotationType == "rotate") {

              startPoint = new createjs.Point(startPoint.x, startPoint.y + 30);
              rectanglePoint = [
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x - widthPart, startPoint.y),
                new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
                new createjs.Point(startPoint.x, startPoint.y - lengthPart)
              ]
            }
            else {

              startPoint = new createjs.Point(startPoint.x, startPoint.y + 30);
              rectanglePoint = [
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x - widthPart, startPoint.y),
                new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
                new createjs.Point(startPoint.x, startPoint.y - lengthPart),
              ]
            }
            break;
          case 1:
            if (parent.partData.ladder) {
              startPoint = new createjs.Point(startPoint.x, startPoint.y + 30);
              rectanglePoint = [
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x - widthPart, startPoint.y),
                new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
                new createjs.Point(startPoint.x, startPoint.y - lengthPart)
              ]
            }
            else {
              startPoint = new createjs.Point(startPoint.x, startPoint.y + parent.partData.width);
              rectanglePoint = [
                new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x + widthPart, startPoint.y)
              ]
            }

            break;
          case 4:
            startPoint = new createjs.Point(startPoint.x + 30, startPoint.y + parent.partData.width);
            rectanglePoint = [
              new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x + widthPart, startPoint.y)
            ]
            break;
          case 5:
            startPoint = new createjs.Point(startPoint.x + 60, startPoint.y + parent.partData.width);
            rectanglePoint = [
              new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x + widthPart, startPoint.y)
            ]
            break;
          case 6:
            startPoint = new createjs.Point(startPoint.x + 90, startPoint.y + parent.partData.width);
            rectanglePoint = [
              new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x + widthPart, startPoint.y)
            ]
            break;
          case 3:
            if (parent.partData.ladder) {
              let parentLength = (parent.partData.length<0)?-(parent.partData.length) : parent.partData.length;
              startPoint = new createjs.Point(startPoint.x+parentLength, startPoint.y );
              rectanglePoint = [
                new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x + widthPart, startPoint.y),
              ]
              
            }
            else
            {
              startPoint = new createjs.Point(startPoint.x+30, startPoint.y);
              rectanglePoint = [
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x - widthPart, startPoint.y),
                new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
                new createjs.Point(startPoint.x, startPoint.y - lengthPart)
              ]
            }
            break;
          case 7:
            startPoint = new createjs.Point(startPoint.x +60, startPoint.y );
            rectanglePoint = [
              new createjs.Point(startPoint.x, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
              new createjs.Point(startPoint.x, startPoint.y - lengthPart)
            ]
            break;
          case 8:
            startPoint = new createjs.Point(startPoint.x+90, startPoint.y);
            rectanglePoint = [
              new createjs.Point(startPoint.x, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
              new createjs.Point(startPoint.x, startPoint.y - lengthPart)
            ]
            break;
          case 9:
            startPoint = new createjs.Point(startPoint.x+120, startPoint.y);
            rectanglePoint = [
              new createjs.Point(startPoint.x, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y),
              new createjs.Point(startPoint.x - widthPart, startPoint.y - lengthPart),
              new createjs.Point(startPoint.x, startPoint.y - lengthPart)
            ]
            break;
          case 2:
            let parentLength = (parent.partData.length<0)?-(parent.partData.length) : parent.partData.length;

            if(parent.partData.ladder){
              startPoint = new createjs.Point(startPoint.x+parentLength , startPoint.y);
              rectanglePoint = [
                new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x + widthPart, startPoint.y)
              ]
            }
            else
            {
              startPoint = new createjs.Point(startPoint.x + parentLength, startPoint.y );
              rectanglePoint = [
                new createjs.Point(startPoint.x + widthPart, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y + lengthPart),
                new createjs.Point(startPoint.x, startPoint.y),
                new createjs.Point(startPoint.x + widthPart, startPoint.y)
              ]
            }
            break;
        }
      }

    }
    let showDrawPoint = shadowDraw(widthPart, lengthPart, rectanglePoint, color, i, data.bridgeSpan, rotationType, parentConnector);
    startPoint = showDrawPoint.nextPoint;
    minXY = getOverAll(minXY,rectanglePoint)
    i++;
  }
  let totalLength = new createjs.Shape();
  totalLength.graphics.beginStroke("#66ff1a").setStrokeStyle(2, 2);
  totalLength.graphics.moveTo(minXY.maxX+10, minXY.maxY);
  totalLength.graphics.lineTo(minXY.maxX+10, minXY.maxY);
  totalLength.graphics.lineTo(minXY.maxX+10,minXY.maxY -((minXY.maxY - minXY.minY)/2-10));
  topDownViewParts.addChild(totalLength);

  let totalLengthFull = new createjs.Shape();
  totalLengthFull.graphics.beginStroke("#66ff1a").setStrokeStyle(2, 2);
  totalLengthFull.graphics.moveTo(minXY.maxX+10, minXY.maxY -((minXY.maxY - minXY.minY)/2)-4);
  
  totalLengthFull.graphics.lineTo(minXY.maxX+10,minXY.maxY -((minXY.maxY - minXY.minY)/2)-4);
  totalLengthFull.graphics.lineTo(minXY.maxX+10, minXY.minY);
  topDownViewParts.addChild(totalLengthFull);
  let lengthInch= ((minXY.maxY - minXY.minY)%12 == 0)? "" : Math.floor((minXY.maxY - minXY.minY)%12)+"\"";
  let lengthText = new createjs.Text(Math.floor((minXY.maxY - minXY.minY)/12)+"\'"+lengthInch,"8px sans-serif", "#66ff1a");
  lengthText.textAlign = "left";
  lengthText.x = minXY.maxX+4;
  lengthText.y = minXY.minY+((minXY.maxY - minXY.minY)/2);
  topDownViewParts.addChild(lengthText);
  
  let totalX = (minXY.maxX - minXY.minX)
let totalWidth = new createjs.Shape();
  totalWidth.graphics.beginStroke("#ffffff").setStrokeStyle(2, 2);
  totalWidth.graphics.moveTo(minXY.minX, minXY.maxY  +10);
  totalWidth.graphics.lineTo(minXY.minX, minXY.maxY +10);
  totalWidth.graphics.lineTo(minXY.minX+(totalX/2)- 8 ,minXY.maxY +10);
  topDownViewParts.addChild(totalWidth);
  
  let widthInch= ((minXY.maxX - minXY.minX)%12 == 0)? "" : Math.floor((minXY.maxX - minXY.minX)%12)+"\"";
  let widthText = new createjs.Text(Math.floor(totalX/12)+"\'"+widthInch,"8px sans-serif", "#ffffff");
  widthText.textAlign = "left";
  widthText.x = minXY.minX+(totalX/2)-5;
  widthText.y = minXY.maxY+6;
  topDownViewParts.addChild(widthText);
  let nextWidthPt = widthText.getMeasuredWidth()+3+(totalX/2)- 5;
  let totalWidthFull = new createjs.Shape();
  totalWidthFull.graphics.beginStroke("#ffffff").setStrokeStyle(2, 2);
  totalWidthFull.graphics.moveTo(minXY.minX+nextWidthPt, minXY.maxY +10);  
  totalWidthFull.graphics.lineTo(minXY.minX+nextWidthPt, minXY.maxY +10);
  totalWidthFull.graphics.lineTo(minXY.maxX, minXY.maxY +10);
  topDownViewParts.addChild(totalWidthFull);
  


  var messageText = new createjs.Text("Total Length = " + Math.floor((minXY.maxY - minXY.minY)/12)  + "\'"+lengthInch+"\nTotal Width = " + +Math.floor((minXY.maxX - minXY.minX)/12) + "\'"+widthInch+"\"", "26px sans-serif", "#FFFFFF");
  messageText.textAlign = "left";
  messageText.x = 10;
  messageText.y = 30;
  topDownView.addChild(messageText);


  updateZOrder();
  sortElements();
  topDownViewParts.scaleX = topDownViewParts.scaleY = 2.5;
  console.log( minXY.minX,minXY.maxX)
  if( minXY.minX <205 ){
    let diffX =( 205-minXY.minX)*2.5;
    let diffD = (-500+diffX > -235)? -235: -500+diffX;
    topDownViewParts.x = diffD;
  }
  else if(minXY.maxX > 555){
    topDownViewParts.x = -500 +((555- minXY.maxX)*2.5)
  }
  else
  {
    topDownViewParts.x = -500;
  }
  if( minXY.maxY +12 > 420 ){
    let diff =( minXY.maxY +12 -420)*2.5;    
    topDownViewParts.y = -300 - diff;
  }
  else
  {
    topDownViewParts.y = -300;
  }
  return topDownView;
}

function shadowDraw(width, length, pointDefine, spanColor, i, isBridge, rotationType, parentConnector) {
  let ladderWidth = new createjs.Text(width + '"', "8px sans-serif", "#FFFFFF");
  ladderWidth.x = pointDefine[0].x - width + 1;
  ladderWidth.y = pointDefine[0].y - 8;
  ladderWidth.name = "widthText_" + i;
  topDownViewParts.addChild(ladderWidth);
  let ladderHeight = new createjs.Text(length + '"', "8px sans-serif", "#66ff1a");
  let minusHeight = (length.toString().length == 3) ? 17 : 13;
  ladderHeight.x = pointDefine[0].x - minusHeight;
  ladderHeight.y = pointDefine[0].y - length + 2;
  ladderHeight.name = "heightText_" + i;
  topDownViewParts.addChild(ladderHeight);
  if(isBridge){
    if(rotationType == "default")
    {
      let leg1 = new createjs.Shape();
      leg1.graphics.beginStroke("#FF2020").setStrokeStyle(2,2);
      leg1.graphics.moveTo(pointDefine[0].x, pointDefine[0].y);
      leg1.graphics.lineTo(pointDefine[1].x, pointDefine[1].y);
      leg1.PRIORITY = 2;
      topDownViewParts.addChild(leg1);
      let leg2 = new createjs.Shape();
      leg2.graphics.beginStroke("#FF2020").setStrokeStyle(2,2);
      leg2.graphics.moveTo(pointDefine[2].x, pointDefine[2].y);
      leg2.graphics.lineTo(pointDefine[3].x, pointDefine[3].y);
      leg2.PRIORITY = 2;
      topDownViewParts.addChild(leg2);
    }else{
      let leg1 = new createjs.Shape();
      leg1.graphics.beginStroke("#FF2020").setStrokeStyle(2,2);
      leg1.graphics.moveTo(pointDefine[1].x, pointDefine[1].y);
      leg1.graphics.lineTo(pointDefine[2].x, pointDefine[2].y);
      leg1.PRIORITY = 2;
      topDownViewParts.addChild(leg1);
      let leg2 = new createjs.Shape();
      leg2.graphics.beginStroke("#FF2020").setStrokeStyle(2,2);
      leg2.graphics.moveTo(pointDefine[0].x, pointDefine[0].y);
      leg2.graphics.lineTo(pointDefine[3].x, pointDefine[3].y);
      leg2.PRIORITY = 2;
      topDownViewParts.addChild(leg2);
    }
  }
  else{
    
  }
  let ladderShape = new createjs.Shape();
  ladderShape.graphics.beginFill(spanColor).beginStroke("#000000").setStrokeStyle(1, 1);
  ladderShape.graphics.moveTo(pointDefine[0].x, pointDefine[0].y);
  ladderShape.graphics.lineTo(pointDefine[1].x, pointDefine[1].y);
  ladderShape.graphics.lineTo(pointDefine[2].x, pointDefine[2].y);
  ladderShape.graphics.lineTo(pointDefine[3].x, pointDefine[3].y);
  ladderShape.graphics.lineTo(pointDefine[0].x, pointDefine[0].y);
  ladderShape.name = "shaped_" + i;
  topDownViewParts.addChild(ladderShape);
  let nPoint = (rotationType == "default") ? pointDefine[3] : pointDefine[2];
  
  // let nextPoint = new createjs.Shape();  
  // nextPoint.graphics.beginFill(spanColor).beginStroke("#000000").drawCircle(nPoint.x, nPoint.y, 4);
  // topDownViewParts.addChild(nextPoint);
  return { nextPoint: new createjs.Point(nPoint.x, nPoint.y) }
  // if(isBridge){
  //   if(rotationType=="default"){

  //   }
  // }
  // "rgba(255,192,0,0.75)" orange
  // "rgba(192,192,192,0.75)" gray
}

function movePlatform(data) {

  let yAdd = 0;
  switch (data.rotationType) {
    case 5:
      yAdd = 30;
      break;
    case 4:
      yAdd = 60;
      break;
    case 3:
      yAdd = 90;
      break;
  }
  if (data.length == 90 && data.rotationType != 6) {
    yAdd -= 30;
  }
  if (data.length == 60 && data.rotationType == 3) {
    yAdd = 30;
  }
  return yAdd;
}

function rotationTopDown(data) {
  let rotationType;

  if (!data || data.noParent) {
    rotationType = "default"
  }
  else if (data.partData.ladder || (data.partData.bridgeSpan && data.partData.length == 30)) {
    let parent = getRotationType(data.parentPart.partData.defaultName);
    let connector = parseInt(data?.parentConnector ?? 2);
    if ([0, 2].includes(connector)) {
      rotationType = parent;
    }
    else {
      rotationType = (parent == "default") ? "rotate" : "default";
    }
  } else {
    rotationType = getRotationType(data.partData.defaultName);
  }
  return rotationType;
}
function getOverAll(minXY, points){
  for(let pt of points){
    if(minXY.minX > pt.x){
      minXY.minX = pt.x;
    }else if(minXY.maxX < pt.x){
      minXY.maxX = pt.x;
    }
    if(minXY.minY > pt.y){
      minXY.minY = pt.y;
    }else if(minXY.maxY < pt.y){
      minXY.maxY = pt.y;
    }
  }
  console.log(points,minXY)
  return minXY;
}

function getConnector(length, rotationType, parentConnector, isPlatForm){
 let connector;
 switch (true){
  case length == 30 && rotationType =="rotate" && isPlatForm == true:
    switch(parentConnector ){
      case 0:
        connector =3;
        break;
      case 1:
        connector = 0;
        break;
      case 2:
        connector =1;
        break;
      case 3:
        connector = 2;
        break;
    }
    break;
  default:
    connector = parentConnector
 }
 console.log("connector", connector, rotationType, length == 30 && rotationType =="rotate", length )
 return connector;
}
