/* Controllers */
var scope;
var showTable;
var modalInstance;
var configuratorApp = angular.module('configuratorApp', ['ui.bootstrap']);
configuratorApp.controller('ConfiguratorCtrl', ['$scope', '$window', '$modal', function ($scope, $window, $modal) {
  if (scope == null)
    scope = $scope;

  $scope.openModal = function () {
    modalInstance = $modal.open({
      templateUrl: 'form.html',
      controller: ModalInstanceCtrl,
      scope: $scope,
      dialogClass: 'modal form'
    });
  }

  $scope.closeModal = function () {
    modalInstance.dismiss('cancel');
  }
}]);


function angularUpdate(parts) {
  if(system != 4){
    var summaryParts = new Array();
    for (var i = 0; i < parts.length; i++) {
      var part = partsContainer.getChildByName(parts[i]);
      
      var found = false;
      for (var j = 0; j < summaryParts.length; j++) {
        if (summaryParts[j].sku == part.partData.sku) {
          summaryParts[j].quantity++;
          found = true;
          break;
        }
        
      }
      if (!found) {
        summaryParts.push(summaryEntry(part.partData));
      }
    }
    scope.showTable = showTable;
    scope.parts = summaryParts;
    scope.$apply();
  }else{
    angularMPASUpdate(parts);
  }
}

function angularMPASUpdate(parts) {
  let summaryParts = [];
  let found = [];
  let addedParts = {};
  for (var i = 0; i < parts.length; i++) {
    let part = partsContainer.getChildByName(parts[i]).partData;
    if(found.includes(part.sku)){
      let j = found.indexOf(part.sku);
      summaryParts[j].quantity++;
      if(addedParts.hasOwnProperty(part.sku)){
        let k = found.indexOf(addedParts[part.sku]);
        summaryParts[k].quantity +=2;
      }
    }else{
      summaryParts.push(summaryEntry(part));
      found.push(part.sku);
      if(part.ladder){
        switch (part.sku) {
          case "MPASSW2":
            summaryParts.push(summaryEntry({
              sku: "MPASHR2",
              gsku: "MPASHR2",
              description: "36.5\"H Stair Handrails",
              quantity: 2
            }));
            found.push("MPASHR2");
            addedParts[part.sku] = "MPASHR2";
            break;
          case "MPASSW3":
            summaryParts.push(summaryEntry({
              sku: "MPASHR3",
              gsku: "MPASHR3",
              description: "36.5\"H Stair Handrails",
              quantity: 2
            }));
            found.push("MPASHR3");
            addedParts[part.sku] = "MPASHR3";
            break;
          case "MPASSW4":
            summaryParts.push(summaryEntry({
              sku: "MPASHR4",
              gsku: "MPASHR4",
              description: "36.5\"H Stair Handrails",
              quantity: 2
            }));
            found.push("MPASHR4");
            addedParts[part.sku] = "MPASHR4";
            break;
          case "MPASSW5":
            summaryParts.push(summaryEntry({
              sku: "MPASHR5",
              gsku: "MPASHR5",
              description: "36.5\"H Stair Handrails",
              quantity: 2
            }));
            found.push("MPASHR5");
            addedParts[part.sku] = "MPASHR5";
            break;
          case "MPASSW6":
            summaryParts.push(summaryEntry({
              sku: "MPASHR6",
              gsku: "MPASHR6",
              description: "36.5\"H Stair Handrails",
              quantity: 2
            }));
            found.push("MPASHR6");
            addedParts[part.sku] = "MPASHR6";
            break;
          case "MPASSW7":
            summaryParts.push(summaryEntry({
              sku: "MPASHR7",
              gsku: "MPASHR7",
              description: "36.5\"H Stair Handrails",
              quantity: 2
            }));
            found.push("MPASHR7");
            addedParts[part.sku] = "MPASHR7";
            break;
          case "MPASSW8":
            summaryParts.push(summaryEntry({
              sku: "MPASHR8",
              gsku: "MPASHR8",
              description: "36.5\"H Stair Handrails",
              quantity: 2
            }));
            found.push("MPASHR8");
            addedParts[part.sku] = "MPASHR8";
            break;
          case "MPASSW9":
            summaryParts.push(summaryEntry({
              sku: "MPASHR9",
              gsku: "MPASHR9",
              description: "36.5\"H Stair Handrails",
              quantity: 2
            }));
            found.push("MPASHR9");
            addedParts[part.sku] = "MPASHR9";
            break;
      
        }
      }
    }
    if(part.bridgeSpan){
      let bar = (part.bridgeHeight/10)+1;
      let elem ={
        sku: `MPASST${bar}`,
            gsku: `MPASST${bar}`,
            description: `${(bar*10)-bar}\"H platform support legs`,
            quantity: 2
      }
      if(found.includes(elem.sku))
      {
        let k = found.indexOf(elem.sku);
        summaryParts[k].quantity +=2;
      }
      else{
        summaryParts.push(summaryEntry(elem));
        found.push(elem.sku);
      }
    }
  }
  scope.showTable = showTable;
  scope.parts = summaryParts;
  scope.$apply();

}

var ModalInstanceCtrl = function ($scope, $modalInstance) {
  $scope.renderPrintView = function () {
    var printWindow = window.open("", "MsgWindow", "width=960,height=960");
    printWindow.document.write("<link rel='stylesheet' type='text/css' href='css/bootstrap.min.css'><div class='row'><img style='display: block; margin-left: auto; margin-right: auto' src='assets/UDesignLogo.jpg'></div><BR><div class='container'><h4 align='center'>Components in Configuration</h4><div class='container'><table class='table table-bordered table-responsive'><tr><th>Tri-Arc Part #</th><th>Quantity</th><th>Description</th></tr>");
    for (var i = 0; i < scope.parts.length; i++) {
      printWindow.document.write("<tr><td>" + scope.parts[i].sku + "</td><td>" + scope.parts[i].quantity + "</td><td>" + scope.parts[i].description + "</td></tr>");
    }
    printWindow.document.write("</table></div></div><div class='row'><div class='col-sm-12'><table class='table table-responsive'><tr><td><img src='assets/TriArcLogo.jpg'></td><td></td><td></td></table></div></div>")
    printWindow.document.write("<img src='" + scope.imageData + "'>")
    if(system!=4){
      printWindow.document.write("<img src='" + scope.overviewImage + "'>")
    }
    printWindow.document.focus();
    printWindow.print();
  };
}

function summaryEntry(partData) {
  var entry = {
    sku: partData.sku,
    price: partData?.price ?? 0,
    gsku: partData.gsku,
    description: partData.description,
    quantity: partData?.quantity ?? 1,
    cost: partData?.price ?? 0
  };
  if(typeof treadType !== 'undefined'&& system == 4 && treadType == 'ss'){
    entry.sku = entry.sku+"-S";
  }
  return entry;
}

function exportImage() {
  focusCanvas();
  scope.imageData = stage.toDataURL();
  stage.update();
  if (system != 3)
    stage.addChild(TopDownView(true));
  else
    stage.addChild(MaxTopDownView(true));
  stage.update();
  scope.overviewImage = stage.toDataURL();
  scope.completed = true;
  restoreCanvas();
  if (!VENDOR) {
    scope.openModal();
    scope.$apply();
  }
  else {
    var printWindow = window.open("", "MsgWindow", "width=960,height=960");
    printWindow.document.write("<link rel='stylesheet' type='text/css' href='css/bootstrap.min.css'><div class='row'><img style='display: block; margin-left: auto; margin-right: auto' src='assets/UDesignLogo.jpg'></div><BR><div class='container'><h4 align='center'>Components in Configuration</h4><div class='container'><table class='table table-bordered table-responsive'><tr><th style='color:red;'>Grainger Stock No.</th><th>Tri-Arc Part #</th><th>Quantity</th><th>Description</th></tr>");
    for (var i = 0; i < scope.parts.length; i++) {
      printWindow.document.write("<tr><td style='color:red;'>" + scope.parts[i].gsku + "</td><td>" + scope.parts[i].sku + "</td><td>" + scope.parts[i].quantity + "</td><td>" + scope.parts[i].description + "</td></tr>");
    }
    printWindow.document.write("</table></div></div><div class='row'><div class='col-sm-12'><table class='table table-responsive'><tr><td><img src='assets/TriArcLogo.jpg'></td><td></td><td><img style='float:right' src='assets/GraingerLogo.jpg'></td></table></div></div>")
    printWindow.document.write("<img src='" + scope.imageData + "'>")
    printWindow.document.write("<img src='" + scope.overviewImage + "'>")
    printWindow.focus();
    printWindow.print();
    scope.$apply();
  }
}

function submitForm(form) {
  form.parts.value = "<table class='table table-bordered table-responsive'><tr><th>Tri-Arc Part #</th><th>Quantity</th><th>Description</th></tr>";
  for (var i = 0; i < scope.parts.length; i++) {
    form.parts.value += "<tr><td>" + scope.parts[i].sku + "</td><td>" + scope.parts[i].quantity + "</td><td>" + scope.parts[i].description + "</td></tr>";
  }
  form.parts.value += "</table>";
  form.image.value = scope.imageData;
  form.overviewImage.value = scope.overviewImage;
  if (form.name.value.length < 1 || form.company.value.length < 1 || form.email.value.length < 1 || form.phone.value.length < 1)
    return;
  $.ajax({
    url: 'https://tri-arc.com/configurator/mailer.php',
    method: 'POST',
    type: "json",
    data: {
      name: form.name.value,
      company: form.company.value,
      phone: form.phone.value,
      email: form.email.value,
      parts: form.parts.value,
      zipcode: form.zipcode.value,
      comments: form.comments.value,
      referrer: form.referrer.value,
      image: form.image.value,
      overviewImage: form.overviewImage.value
    },
    success: function (msg) {
      msg = JSON.parse(msg);
      if(msg.status == 'success') {
        alert("Email Sent");
      } else {
        alert("Something went wrong");
      }
    }
  });
}
