// Global Access



var configuratorContainer;

var partsContainer;

var minZoom = 0.5;

var maxZoom = 1.5;

var VENDOR = false;



var parts = new Array();

var camAngle;

var currentFrame;



var length;

var width;

var blength;

var bwidth;

var iwidth;





var partsMenuContainer;

var partsMenuContainerText;

var upperPartsMenuClip;

var heightTintButtonText;



// Configurator View

function ConfiguratorContainer(){

  camAngle = 0;

  currentFrame = 0;

  var container = new createjs.Container();

  container.name = "CONFIGURATOR_CONTAINER";

  configuratorContainer = container;



  // Draggable Container

  container.on("mousedown", function(evt){

    this.offset = {x:this.x-evt.stageX, y:this.y-evt.stageY};

  });



  container.on("pressmove", function(evt) {

        this.x = evt.stageX + this.offset.x;

        this.y = evt.stageY + this.offset.y;

      });



  // Background

  var containerBackground = new createjs.Shape();

  containerBackground.graphics.beginFill("#FFF").drawRect(-2048,-2048,4096,4096);

  container.addChild(containerBackground);



  // Parts Container

  partsContainer = new createjs.Container();

  partsContainer.x = 480;

  partsContainer.y = 400;

  partsContainer.name = "CONFIGURATOR_PARTS_CONTAINER";

  container.addChild(partsContainer);

  return container;

}



function showConfiguratorButtons(){
  partsMenuContainer = new createjs.Container();

  partsMenuContainer.name = "PARTS_MENU_CONTAINER";

  partsMenuContainer.x = 700;

  partsMenuContainer.y = 45;

  stage.addChild(partsMenuContainer);



  var partsMenuOutline = new createjs.Shape();

  partsMenuOutline.graphics.beginFill("#ffffff").beginStroke("#e17a0f").drawRoundRect(0,-10,260,730,5);

  partsMenuContainer.addChild(partsMenuOutline);



  upperPartsMenuClip = new createjs.Shape();

  upperPartsMenuClip.graphics.beginFill("#fff").drawRect(5,1,250,17);

  partsMenuContainer.addChild(upperPartsMenuClip);



  partsMenuContainerText = new createjs.Text("Click a part to show available\nparts to connect to it", "15px sans-serif", "#444");

  partsMenuContainerText.x = 130;

  partsMenuContainerText.y = 0;

  partsMenuContainerText.textAlign = "center";

  partsMenuContainer.addChild(partsMenuContainerText);



  var topPartClipping = new createjs.Shape();

  topPartClipping.graphics.beginFill("#fff").drawRect(705,0,250,48);

  stage.addChild(topPartClipping);



  var bottomPartClip = new createjs.Shape();

  bottomPartClip.graphics.beginFill("#fff").drawRect(705,750,250,100);

  stage.addChild(bottomPartClip);





  var resetButton = new createjs.Container();

  resetButton.x = 700;

  resetButton.name = "RESET_BUTTON";



  stage.addChild(resetButton);



  var resetButtonShape = new createjs.Shape();

  resetButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,260,40,5);

  resetButton.addChild(resetButtonShape);



  var resetButtonText = new createjs.Text("Reset", "20px sans-serif", "#fff");

  resetButtonText.textAlign = "center";

  resetButtonText.y = 10;

  resetButtonText.x = 130;



  resetButton.addChild(resetButtonText);



  var resetButtonHelper = new createjs.ButtonHelper(resetButton);

  resetButton.addEventListener("click", handleResetButtonClicked);



  var finishButton = new createjs.Container();

  finishButton.name = "FINISH_BUTTON";

  finishButton.x = 700;

  finishButton.y = 750;



  stage.addChild(finishButton);



  var finishButtonShape = new createjs.Shape();

  finishButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,260,60,5);

  finishButton.addChild(finishButtonShape);

 let finishButtonText = new createjs.Text((system == 4)?"Submit For Dimensional\ndrawings":"Complete", "20px sans-serif", "#fff");

  finishButtonText.name = "finishText";
  finishButtonText.textAlign = "center";

  finishButtonText.y = (system==4)?5:10;

  finishButtonText.x = 130;



  finishButton.addChild(finishButtonText);



  var finishButtonHelper = new createjs.ButtonHelper(finishButton);

  finishButton.addEventListener("click", handleFinishButtonClicked);



  var zoomContainer = new createjs.Container();

  zoomContainer.name = "ZOOM_CONTAINER";

  zoomContainer.x = 10;

  zoomContainer.y = 20;

  stage.addChild(zoomContainer);



  var zoomContainerShape = new createjs.Shape();

  zoomContainerShape.graphics.beginFill("#BBB").beginStroke("#e17a0f").drawRoundRect(0,0,120,80,5);

  zoomContainer.addChild(zoomContainerShape);





  var zoomText = new createjs.Text("Zoom", "20px sans-serif", "#FFF");

  zoomText.textAlign = "center";

  zoomText.x = 60;

  zoomText.y = 10;



  zoomContainer.addChild(zoomText);



  var zoomInButton = new createjs.Container();

  zoomInButton.x = 75;

  zoomInButton.y = 40;



  zoomContainer.addChild(zoomInButton);



  var zoomInButtonShape = new createjs.Shape();

  zoomInButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,25,25,5);

  zoomInButton.addChild(zoomInButtonShape);



  var zoomInButtonText = new createjs.Text("+", "30px sans-serif", "#FFF");

  zoomInButtonText.textAlign = "center";

  zoomInButtonText.y = -7;

  zoomInButtonText.x = 12;

  zoomInButton.addChild(zoomInButtonText);



  var zoomInButtonHelper = new createjs.ButtonHelper(zoomInButton);

  zoomInButton.addEventListener("click", handleZoomInClicked);



  var zoomOutButton = new createjs.Container();

  zoomOutButton.x = 20;

  zoomOutButton.y = 40;



  zoomContainer.addChild(zoomOutButton);



  var zoomOutButtonShape = new createjs.Shape();

  zoomOutButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,25,25,5);

  zoomOutButton.addChild(zoomOutButtonShape);



  var zoomOutButtonText = new createjs.Text("-", "30px sans-serif", "#FFF");

  zoomOutButtonText.textAlign = "center";

  zoomOutButtonText.y = -7;

  zoomOutButtonText.x = 12;

  zoomOutButton.addChild(zoomOutButtonText);



  var zoomOutButtonHelper = new createjs.ButtonHelper(zoomOutButton);

  zoomOutButton.addEventListener("click", handleZoomOutClicked);



  var bInstructionText = new createjs.Text("Click Anywhere and Drag to Move the Ladder System", "16px sans-serif", "#444");

  bInstructionText.textAlign = "center";

  bInstructionText.x = 480;

  bInstructionText.y = 780;

  bInstructionText.name = "BINSTRUCTION_TEXT";

  stage.addChild(bInstructionText);



  var topDownButton = new createjs.Container();

  topDownButton.name = "TOP_DOWN_BUTTON";

  topDownButton.x = 10;

  topDownButton.y = 100;

  stage.addChild(topDownButton);



  var topDownButtonShape = new createjs.Shape();

  topDownButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,120,60,5);

  topDownButton.addChild(topDownButtonShape);



  var topDownButtonText = new createjs.Text("Top-Down\nView", "16px sans-serif", "#FFF");
  if(system == 4){
    topDownButtonText = new createjs.Text("Overall\nDimensions", "16px sans-serif", "#FFF");
  }

  topDownButtonText.textAlign = "center";

  topDownButtonText.y = 10;

  topDownButtonText.x = 60;

  topDownButton.addChild(topDownButtonText);



  var topDownButtonHelper = new createjs.ButtonHelper(topDownButton);

  topDownButton.addEventListener("click", handleTopDownButtonClicked);



  // if(system == 3){

  //   addHeightKeys();

  //   var heightTintButton = new createjs.Container();

  //   heightTintButton.name = "HEIGHT_TINT_BUTTON";

  //   heightTintButton.x = 10;

  //   heightTintButton.y = 280;



  //   stage.addChild(heightTintButton);



  //   var heightTintButtonShape = new createjs.Shape();

  //   heightTintButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,120,60,5);

  //   heightTintButton.addChild(heightTintButtonShape);



  //   heightTintButtonText = new createjs.Text("Show\nHeight Tints", "16px sans-serif", "#FFF");

  //   heightTintButtonText.textAlign = "center";

  //   heightTintButtonText.y = 10;

  //   heightTintButtonText.x = 60;

  //   heightTintButton.addChild(heightTintButtonText);



  //   var heightTintButtonHelper = new createjs.ButtonHelper(heightTintButton);

  //   heightTintButton.addEventListener("click", handleHeightTintButtonClicked);



  //   var autoRailsButton = new createjs.Container();

  //   autoRailsButton.x = 10;

  //   autoRailsButton.y = 160;

  //   autoRailsButton.name = "AUTO_RAILS_BUTTON";

  //   stage.addChild(autoRailsButton);



  //   var autoRailsButtonShape = new createjs.Shape();

  //   autoRailsButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,120,60,5);

  //   autoRailsButton.addChild(autoRailsButtonShape);



  //   var autoRailsButtonText = new createjs.Text("Auto Add Rails", "16px sans-serif", "#FFF");

  //   autoRailsButtonText.textAlign = "center";

  //   autoRailsButtonText.y = 20;

  //   autoRailsButtonText.x = 60;

  //   autoRailsButton.addChild(autoRailsButtonText);



  //   var autoRailsButtonHelper = new createjs.ButtonHelper(autoRailsButton);

  //   autoRailsButton.addEventListener("click", handleAutoRailsButtonClicked);



  //   var undoAutoRailsButton = new createjs.Container();

  //   undoAutoRailsButton.x = 10;

  //   undoAutoRailsButton.y = 220;

  //   undoAutoRailsButton.name = "UNDO_AUTO_RAILS_BUTTON";

  //   stage.addChild(undoAutoRailsButton);



  //   var undoAutoRailsButtonShape = new createjs.Shape();

  //   undoAutoRailsButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,120,60,5);

  //   undoAutoRailsButton.addChild(undoAutoRailsButtonShape);



  //   var undoAutoRailsButtonText = new createjs.Text("Undo Auto\nAdd Rails", "16px sans-serif", "#FFF");

  //   undoAutoRailsButtonText.textAlign = "center";

  //   undoAutoRailsButtonText.y = 10;

  //   undoAutoRailsButtonText.x = 60;

  //   undoAutoRailsButton.addChild(undoAutoRailsButtonText);



  //   var undoAutoRailsButtonHelper = new createjs.ButtonHelper(undoAutoRailsButton);

  //   undoAutoRailsButton.addEventListener("click", handleUndoAutoRailsButtonClicked);

  // }

}



function showResetWarning(){

  var resetWarningContainer = new createjs.Container();

  resetWarningContainer.name = "RESET_WARNING_CONTAINER";

  stage.addChild(resetWarningContainer);



  var resetWarningBackground = new createjs.Shape();

  resetWarningBackground.graphics.beginFill("#333").drawRect(0,0,stage.getBounds().width,stage.getBounds().height);

  resetWarningContainer.addChild(resetWarningBackground);



  var resetWarningText = new createjs.Text("Resetting will lose all progress.\nContinue?", "40px sans-serif", "#F33");

  resetWarningText.y = 50;

  resetWarningText.x = stage.getBounds().width/2;

  resetWarningText.textAlign = "center";

  resetWarningContainer.addChild(resetWarningText);



  var confirmResetButton = new createjs.Container();

  confirmResetButton.x = 450;

  confirmResetButton.y = 450;

  resetWarningContainer.addChild(confirmResetButton);



  var confirmResetButtonText = new createjs.Text("Continue", "20px sans-serif", "#F44");

  confirmResetButtonText.textAlign = "center";

  confirmResetButtonText.y = 20;

  confirmResetButtonText.x = 50;

  confirmResetButton.addChild(confirmResetButtonText);



  var confirmResetButtonShape = new createjs.Shape();

  confirmResetButtonShape.graphics.beginStroke("#F44").drawRoundRect(0,0,100,60,5);

  confirmResetButton.addChild(confirmResetButtonShape);



  var confirmResetButtonHelper = new createjs.ButtonHelper(confirmResetButton);

  confirmResetButton.addEventListener("click", handleConfirmResetButtonClicked);



  var cancelResetButton = new createjs.Container();

  cancelResetButton.x = 50;

  cancelResetButton.y = 450;

  resetWarningContainer.addChild(cancelResetButton);



  var cancelResetButtonText = new createjs.Text("Cancel", "20px sans-serif", "#F44");

  cancelResetButtonText.textAlign = "center";

  cancelResetButtonText.y = 20;

  cancelResetButtonText.x = 50;

  cancelResetButton.addChild(cancelResetButtonText);



  var cancelResetButtonShape = new createjs.Shape();

  cancelResetButtonShape.graphics.beginStroke("#F44").drawRoundRect(0,0,100,60,5);

  cancelResetButton.addChild(cancelResetButtonShape);



  var cancelResetButtonHelper = new createjs.ButtonHelper(cancelResetButton);

  cancelResetButton.addEventListener("click", handleCancelResetButtonClicked);



}



// Event Handlers

function handleResetButtonClicked(event){

  showStartMenu();

}



function handleConfirmResetButtonClicked(event){

  showStartMenu();

}



function handleCancelResetButtonClicked(event){

  stage.removeChild(stage.getChildByName("RESET_WARNING_CONTAINER"));

}



function handleFinishButtonClicked(event){

  if(system != 3)

    exportImage();

  else

    showAutoRailsPopup(true);

}



function handleZoomInClicked(event){

  if(configuratorContainer.scaleY < 1.41){

    configuratorContainer.scaleX += 0.1;

    configuratorContainer.scaleY += 0.1;

  }

}



function handleZoomOutClicked(event){

  if(configuratorContainer.scaleY > 0.51){

    configuratorContainer.scaleX -= 0.1;

    configuratorContainer.scaleY -= 0.1;

  }

}



function focusCanvas(){
  if(system!=4){
    stage.removeChild(stage.getChildByName("ZOOM_CONTAINER"));

    stage.removeChild(stage.getChildByName("RESET_BUTTON"));

    stage.removeChild(stage.getChildByName("FINISH_BUTTON"));

    stage.removeChild(stage.getChildByName("INSTRUCTION_TEXT"));

    stage.removeChild(stage.getChildByName("BINSTRUCTION_TEXT"));

    stage.removeChild(stage.getChildByName("PARTS_MENU_CONTAINER"));

    stage.removeChild(stage.getChildByName("TOP_DOWN_BUTTON"));
  }
  else{
    for(let i =0; i<stage.getNumChildren(); i++){
      let stg = stage.getChildAt(i);
      console.log(i,stg)
      if(stg?.name!="CONFIGURATOR_CONTAINER"){
        stage.removeChild(stg);
      }
    }
  }
  

  if(system == 3){

    stage.removeChild(stage.getChildByName("HEIGHT_TINT_BUTTON"));

    stage.removeChild(stage.getChildByName("AUTO_RAILS_BUTTON"));

    stage.removeChild(stage.getChildByName("UNDO_AUTO_RAILS_BUTTON"));

    if(LAST_CLICKED_MAX_ACCESS_PART != null)

      LAST_CLICKED_MAX_ACCESS_PART.highlight.visible = false;

  }

  stage.update();



  stage.canvas.width = (system!=4)? 680:configuratorContainer.getBounds().width ;

  stage.canvas.height = (system!=4)? 600:configuratorContainer.getBounds().height;

  stage.x = 00;

  stage.y = 00;

  configuratorContainer.x = -(configuratorContainer.getBounds().x*configuratorContainer.scaleX);

  configuratorContainer.y = -(configuratorContainer.getBounds().y*configuratorContainer.scaleY);

  configuratorContainer.scaleX = configuratorContainer.scaleY  =1;

  stage.scaleX = 0.4;

  stage.scaleY = 0.4;

  stage.update();

}



function restoreCanvas(){

  if(system!=3)

    stage.removeChild(topDownView);

  else

    stage.removeChild(maxTopDownView);

  stage.scaleX = 1;

  stage.scaleY = 1;

  stage.canvas.width = 960;

  stage.canvas.height = 800;

  stage.x = 0;

  stage.y = 0;

  stage.update();

  showConfiguratorButtons()

  if(system != 3)

    SelectPartMenu(originalPart);

  else

    addMaxRemoveButton();

  stage.update();

}





// Z Order for parts

function updateZOrder(){

  if(system != 3){

    if(camAngle % 360 == -90 || camAngle % 360 == -180 ||

      camAngle % 360 == 180 || camAngle % 360 == 270){
        
      defaultZOrdering();
      }
    else{

      inverseZOrdering();

    }

      

  }

}



function defaultPartsOrder(){

  var sortFunction = function(obj1, obj2, options){

    if(parts.indexOf(obj1.name) > parts.indexOf(obj2.name))

      return 1;

    if(parts.indexOf(obj1.name) < parts.indexOf(obj2.name))

      return -1;

    return 0;

  }

  partsContainer.sortChildren(sortFunction);

}



function defaultZOrdering(){

  var sortFunction = function(obj1, obj2, options){

    if(obj1.zOrderMod == obj2.zOrderMod){

      if(parts.indexOf(obj1.name) > parts.indexOf(obj2.name))

        return 1;

      if(parts.indexOf(obj1.name) < parts.indexOf(obj2.name))

        return -1;

      return 0;

    }

    else{

      if(obj1.zOrderMod > obj2.zOrderMod)

        return 1;

      if(obj1.zOrderMod < obj2.zOrderMod)

        return -1;

      return 0;

    }

  }

  partsContainer.sortChildren(sortFunction);

}



function inverseZOrdering(){

  var sortFunction = function(obj1, obj2, options){
    if(obj1.iZOrderMod == obj2.iZOrderMod){

      if(parts.indexOf(obj1.name) < parts.indexOf(obj2.name))

        return 1;

      if(parts.indexOf(obj1.name) > parts.indexOf(obj2.name))

        return -1;

      return 0;

    }

    else{

      if(obj1.iZOrderMod > obj2.iZOrderMod)

        return 1;

      if(obj1.iZOrderMod < obj2.iZOrderMod)

        return -1;

      return 0;

    }

  }

  partsContainer.sortChildren(sortFunction);

}



function handleTopDownButtonClicked(event){
  if(system == 3)
    stage.addChild(MaxTopDownView());
  else if(system == 4 )
    stage.addChild(TopDownMPASView());
  else
    stage.addChild(TopDownView());
    

}



function handleHeightTintButtonClicked(event){

  showHeightTints = !showHeightTints;

  if(showHeightTints){

    for(var i=0; i<heightTints.length; i++)

    {

      heightTints[i].visible = true;

    }

    for(var i=0; i<heightKeys.length; i++)

    {

      heightKeys[i].visible = true;

    }

    heightTintButtonText.text = "Hide\n Height Tints";

  }

  else {

    for(var i=0; i<heightTints.length; i++)

    {

      heightTints[i].visible = false;

    }

    for(var i=0; i<heightKeys.length; i++)

    {

      heightKeys[i].visible = false;

    }

    heightTintButtonText.text = "Show\n Height Tints";

  }

}



function handleAutoRailsButtonClicked(event){

  showAutoRailsPopup(false);

}



function handleUndoAutoRailsButtonClicked(event){

  removeAutoAddedRails();

}



function showAddedTip(){

  var msg;

  if(system == 1)

  {

    msg = "All 90\xB0 ladders come with anti tip \nbase extension not shown. \n\nA 7\" gap between the ladder and\nthe platform is required per code";

  }

  else if (system == 2 && height >= 60)

  {

    msg = "FOR ADDED STABILITY OUTRIGGERS HAVE BEEN ADDED \n(ADD 29\" ON EACH SIDE OF 90\xB0 LADDERS)\n\nA 7\" gap between the ladder and\nthe platform is required per code";

  }

  else if (system == 2)

  {

    msg = "A 7\" gap between the ladder and\nthe platform is required per code";

  }

  var popup = new createjs.Container();

  popup.name = "TIP_POPUP";

  stage.addChild(popup);



  var background = new createjs.Shape();

  background.graphics.beginFill("rgba(64,64,64,0.5").drawRect(0,0,1000,1000);

  popup.addChild(background);



  var popupShape = new createjs.Shape();

  popupShape.graphics.beginFill("#FFF").beginStroke("#e17a0f").drawRoundRect(225,100,510,200,5);

  popup.addChild(popupShape);



  var popupText = new createjs.Text(msg, "18px sans-serif", "#444")

  popupText.textAlign = "center";

  popupText.x = 480;

  popupText.y = 120;

  popup.addChild(popupText);



  var tipOkButton = new createjs.Container();

  tipOkButton.x = 320

  tipOkButton.y = 220;

  popup.addChild(tipOkButton);



  var tipOkButtonShape = new createjs.Shape();

  tipOkButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,320,60,5);

  tipOkButton.addChild(tipOkButtonShape);



  var tipOkButtonText = new createjs.Text("OK", "16px sans-serif", "#FFF");

  tipOkButtonText.textAlign = "center";

  tipOkButtonText.y = 20;

  tipOkButtonText.x = 150;

  tipOkButton.addChild(tipOkButtonText);



  var tipOkButtonHelper = new createjs.ButtonHelper(tipOkButton);

  tipOkButton.addEventListener("click", handletipOkButtonClicked);

}



function handletipOkButtonClicked(event){

  stage.removeChild(stage.getChildByName("TIP_POPUP"));

}



function showAutoRailsPopup(completed) {

  toolTipText.visible = false;

  var popup = new createjs.Container();

  popup.name = "RAILS_POPUP";

  stage.addChild(popup);



  var background = new createjs.Shape();

  background.graphics.beginFill("rgba(64,64,64,0.5").drawRect(0,0,1000,1000);

  popup.addChild(background);



  var popupShape = new createjs.Shape();

  popupShape.graphics.beginFill("#FFF").beginStroke("#e17a0f").drawRoundRect(300,100,360,500,5);

  popup.addChild(popupShape);



  var popupText = new createjs.Text("Platforms at 50\" heights or greater require \nhandrails for code compliance.\n\nExceptions can be made if the platform is \nalongside a wall or machine that will otherwise\nprevent falls.", "16px sans-serif", "#444")

  //popupText.textAlign = "center";

  popupText.x = 320;

  popupText.y = 120;

  popup.addChild(popupText);



  var addAllRailsButton = new createjs.Container();

  addAllRailsButton.x = 320

  addAllRailsButton.y = 300;

  popup.addChild(addAllRailsButton);



  var addAllRailsButtonShape = new createjs.Shape();

  addAllRailsButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,320,60,5);

  addAllRailsButton.addChild(addAllRailsButtonShape);



  var addAllRailsButtonText = new createjs.Text("Close Off All Platforms With Rails", "16px sans-serif", "#FFF");

  addAllRailsButtonText.textAlign = "center";

  addAllRailsButtonText.y = 20;

  addAllRailsButtonText.x = 150;

  addAllRailsButton.addChild(addAllRailsButtonText);



  var addAllRailsButtonHelper = new createjs.ButtonHelper(addAllRailsButton);

  if(!completed)

    addAllRailsButton.addEventListener("click", handleAddAllRailsButtonClicked);

  else

    addAllRailsButton.addEventListener("click", handleAddAllRailsButtonCompletedClicked);



  var add50RailsButton = new createjs.Container;

  add50RailsButton.x = 320

  add50RailsButton.y = 380;

  popup.addChild(add50RailsButton);



  var add50RailsButtonShape = new createjs.Shape();

  add50RailsButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,320,60,5);

  add50RailsButton.addChild(add50RailsButtonShape);



  var add50RailsButtonText = new createjs.Text("Close Off All Platforms 50\" or Higher\n With Rails", "16px sans-serif", "#FFF");

  add50RailsButtonText.textAlign = "center";

  add50RailsButtonText.y = 10;

  add50RailsButtonText.x = 150;

  add50RailsButton.addChild(add50RailsButtonText);



  var add50RailsButtonHelper = new createjs.ButtonHelper(add50RailsButton);

  if(!completed)

    add50RailsButton.addEventListener("click", handleAdd50RailsButtonClicked);

  else

    add50RailsButton.addEventListener("click", handleAdd50RailsButtonCompletedClicked)



  var cancelRailsPopupButton = new createjs.Container();

  cancelRailsPopupButton.x = 320;

  cancelRailsPopupButton.y = 460;

  popup.addChild(cancelRailsPopupButton);



  var cancelRailsPopupButtonShape = new createjs.Shape();

  cancelRailsPopupButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,320,60,5);

  cancelRailsPopupButton.addChild(cancelRailsPopupButtonShape);



  var cancelRailsPopupButtonText = new createjs.Text("Cancel", "16px sans-serif", "#FFF");

  cancelRailsPopupButtonText.y = 20;

  if(completed){

    cancelRailsPopupButtonText.y = 10;

    cancelRailsPopupButtonText.text = "I Have Already Added the Rails\nNeeded for Code Compliance";

  }

  cancelRailsPopupButtonText.textAlign = "center";



  cancelRailsPopupButtonText.x = 150;

  cancelRailsPopupButton.addChild(cancelRailsPopupButtonText);



  var cancelRailsPopupButtonHelper = new createjs.ButtonHelper(cancelRailsPopupButton);

  if(!completed)

    cancelRailsPopupButton.addEventListener("click", handleCancelRailsPopupButtonClicked);

  else

    cancelRailsPopupButton.addEventListener("click", handleCancelRailsCompleteButtonClicked);

}



function handleAddAllRailsButtonClicked(event){

  autoAddRails(true);

  stage.removeChild(stage.getChildByName("RAILS_POPUP"));

}



function handleAdd50RailsButtonClicked(event){

  autoAddRails(false);

  stage.removeChild(stage.getChildByName("RAILS_POPUP"));

}



function handleAddAllRailsButtonCompletedClicked(event){

  autoAddRails(true);

  stage.removeChild(stage.getChildByName("RAILS_POPUP"));

  exportImage();

}



function handleAdd50RailsButtonCompletedClicked(event){

  autoAddRails(false);

  stage.removeChild(stage.getChildByName("RAILS_POPUP"));

  exportImage();

}



function handleCancelRailsPopupButtonClicked(event){

  stage.removeChild(stage.getChildByName("RAILS_POPUP"));

}



function handleCancelRailsCompleteButtonClicked(event){

  stage.removeChild(stage.getChildByName("RAILS_POPUP"));

  exportImage();

}

