var id = 0;
let spriteCentreObj = {};
// Part

function mpasPart(data, parent) {
  spriteCentreObj = { isChange: false };
  //let centerCoords = new createjs.Point(0,0);
  setBridgeHeight(data);
  var container = new createjs.Container();
  if (data?.bridgeSpan) {
    data.bridgeHeight = bridgeHeight;
  }
  if (parent.partData?.bridgeSpan && data?.bridgeSpan) {
    let conn = getConnectorPoint(
      parent?.partData?.connectorSelector,
      data.defaultName,
      parent?.partData?.height,
      data.height,
      parent?.partData?.spriteCenter,
      data.spriteCenter,
      parent?.partData?.defaultName ?? "default",
      data?.rotationType ?? parent?.partData?.connectorSelector
    );
    let userCoordGroup = {
      "default": [
        { current: 0, parent: 2, name: "Front" },
        { current: 1, parent: 3, name: "Left" },
        { current: 2, parent: 0, name: "Back" },
        { current: 3, parent: 1, name: "Right" },

        { current: 1, parent: 3, name: "Left1" },
        { current: 1, parent: 3, name: "Left2" },
        { current: 1, parent: 3, name: "Left3" },

        { current: 3, parent: 1, name: "Right1" },
        { current: 3, parent: 1, name: "Right2" },
        { current: 3, parent: 1, name: "Right3" },
      ],
      "rotate": [
        { current: 0, parent: 3, name: "Front" },
        { current: 1, parent: 0, name: "Left" },
        { current: 2, parent: 1, name: "Back" },
        { current: 3, parent: 2, name: "Right" },

        { current: 4, parent: 0, name: "Left1" },
        { current: 5, parent: 0, name: "Left2" },
        { current: 6, parent: 0, name: "Left3" },

        { current: 7, parent: 2, name: "Right1" },
        { current: 8, parent: 2, name: "Right2" },
        { current: 9, parent: 2, name: "Right3" },
      ]
    }

    if (data.height != 30) {
      data.usedCoordinates = userCoordGroup[getRotationType(data.defaultName)];
    }
    //data.connectorPoint[0] = new createjs.Point(0,0);
    data.connectorPoint[0] = conn;
    container.parentConnector = parent?.partData?.connectorSelector ?? 0;
  }
  else if (data?.ladder) {

    let conn = getLadderCoordinates(data, parent?.partData?.spriteCenter, parent?.partData?.connectorSelector, parent?.partData?.defaultName ?? "default", parseInt(parent?.partData?.height ?? "30"));
    if ((parent?.partData?.height == 90) && getRotationType(parent?.partData?.defaultName) == "rotate") {

      conn = new createjs.Point(conn.x, conn.y + 53);
    }
    if ((parent?.partData?.height == 60) && getRotationType(parent?.partData?.defaultName) == "rotate") {

      conn = new createjs.Point(conn.x, conn.y + 106);
    }
    data.connectorPoint[0] = conn;
    let platformSide = "Back";
    switch (data.side) {
      case 1:
        platformSide = "Left";
        break;
      case 2:
        platformSide = "";
        break;
      case 3:
        platformSide = "Right";
        break;
    }
    if (bridgeHeight != 0) {
      let nextBridge = (bridgeHeight / 10) + 1;
      data.connectableParts = ["MPASP30H" + (nextBridge), "MPASP60H" + (nextBridge) + platformSide, "MPASP90H" + (nextBridge) + platformSide, "MPASP120H" + (nextBridge) + platformSide];
    } else {
      data.connectableParts = [];
    }
    container.parentConnector = parent?.partData?.connectorSelector ?? 0;
  }
  else if (parent.partData?.ladder && data?.bridgeSpan && parent?.partData?.hasOwnProperty("side")) {

    {
      data.connectorPoint[0] = ladderToPlatform(data, parent);
    }
    let userCoordGroup = {
      "default": [
        { current: 0, parent: 2, name: "Front" },
        { current: 1, parent: 3, name: "Left" },
        { current: 2, parent: 0, name: "Back" },
        { current: 3, parent: 1, name: "Right" },

        { current: 1, parent: 3, name: "Left1" },
        { current: 1, parent: 3, name: "Left2" },
        { current: 1, parent: 3, name: "Left3" },

        { current: 3, parent: 1, name: "Right1" },
        { current: 3, parent: 1, name: "Right2" },
        { current: 3, parent: 1, name: "Right3" },
      ],
      "rotate": [
        { current: 0, parent: 3, name: "Front" },
        { current: 1, parent: 0, name: "Left" },
        { current: 2, parent: 1, name: "Back" },
        { current: 3, parent: 2, name: "Right" },

        { current: 4, parent: 0, name: "Left1" },
        { current: 5, parent: 0, name: "Left2" },
        { current: 6, parent: 0, name: "Left3" },

        { current: 7, parent: 2, name: "Right1" },
        { current: 8, parent: 2, name: "Right2" },
        { current: 9, parent: 2, name: "Right3" },
      ]
    }

    if (data.height != 30) {
      data.usedCoordinates = userCoordGroup[getRotationType(data.defaultName)];
    }
    container.parentConnector = parent?.partData?.connectorSelector ?? 0;
  }
  else if (parent.partData?.ladder && data?.bridgeSpan) {
    let connectors = {
      120: new createjs.Point(372, 215),
      90: new createjs.Point(278, 159),
      60: new createjs.Point(186, 108),
      30: new createjs.Point(93, 54)
    }
    data.connectorPoint[0] = connectors[data.height];
    container.parentConnector = parent?.partData?.connectorSelector ?? 2;
  }
  else if (data.rails) {
    container.parentConnector = parent?.partData?.connectorSelector ?? 0;
    let connectorSelector = (data?.neighborPort && data?.neighborPort < container.parentConnector) ? data?.neighborPort : container.parentConnector, side;
    let rotateType = getRotationType(parent?.partData?.defaultName ?? "default");
    let sCenter;
    let spritFrame = {

      images: [data.imagePath],

      frames: data.spritFrame,

      animations: {}

    }
    let coords = [
      new createjs.Point(0, 154),
      new createjs.Point(0, 93),
      new createjs.Point(-93, 100),
      new createjs.Point(-93, 145),

      new createjs.Point(-95, 39),
      new createjs.Point(-184, -13),
      new createjs.Point(-275, -64),

      new createjs.Point(-186, 89),
      new createjs.Point(-279, 36),
      new createjs.Point(-372, -17)
    ]
    let coordsRotate = [
      new createjs.Point(0, -64),
      new createjs.Point(-96, -57),
      new createjs.Point(-372, 153),
      new createjs.Point(-1, -13),

      new createjs.Point(-190, -3),
      new createjs.Point(-283, 50),
      new createjs.Point(-377, 102),

      new createjs.Point(-92, 39),
      new createjs.Point(-186, 94),
      new createjs.Point(-278, 148)
    ]
    if (data.length == 60) {
      coordsRotate[1] = new createjs.Point(-96, -14);
      coordsRotate[4] = new createjs.Point(-190, 42);
      coordsRotate[5] = new createjs.Point(-248 - 35, 97 - 5);
      coordsRotate[3] = new createjs.Point(1, 33);
      coordsRotate[7] = new createjs.Point(-93, 90);
      coordsRotate[8] = new createjs.Point(-186, 143);
    }
    switch (parseInt(parent?.partData?.height ?? "30")) {
      case 120:
        coords[2] = new createjs.Point(-371, -65);
        break;
      case 90:
        coords[2] = new createjs.Point(-280, -15);
        coordsRotate[2] = new createjs.Point(-281, 100);
        break;
      case 60:
        coords[2] = new createjs.Point(-186, 36);
        coordsRotate[2] = new createjs.Point(-187, 47);
        break;
    }
    switch (true) {
      case connectorSelector == 0:
        side = (rotateType == "rotate") ? 3 : 2;
        sCenter = (rotateType == "rotate") ? coordsRotate[connectorSelector] : coords[connectorSelector];
        break;
      case [3, 7, 8, 9].includes(connectorSelector):
        side = (rotateType == "rotate") ? 2 : 1;
        sCenter = (rotateType == "rotate") ? coordsRotate[connectorSelector] : coords[connectorSelector];
        break;
      case [1, 4, 5, 6].includes(connectorSelector):
        side = (rotateType == "rotate") ? 0 : 3;
        sCenter = (rotateType == "rotate") ? coordsRotate[connectorSelector] : coords[connectorSelector];
        break;
      case connectorSelector == 2:
        side = (rotateType == "rotate") ? 1 : 0;
        sCenter = (rotateType == "rotate") ? coordsRotate[connectorSelector] : coords[connectorSelector];
        break;
    }
    switch (true) {
      case parseInt(parent?.partData?.height) == 90 && rotateType == "rotate":
        sCenter = new createjs.Point(sCenter.x, sCenter.y + 53);
        break;
      case parseInt(parent?.partData?.height) == 60 && rotateType == "rotate":
        sCenter = new createjs.Point(sCenter.x, sCenter.y + 106);
        break;

    }
    data.spriteSheet = new createjs.SpriteSheet(getSprite(spritFrame, side, true));

    let mpasData = new defaultMpasData();
    data.connectorPoint[0] = mpasData.getRotateCords([sCenter], data.spriteCenter, parent?.partData?.spriteCenter)[0];

  }
  else {
    //data.rotationMain = getRotationType(data?.defaultName ?? "default");
    container.parentConnector = parent?.partData?.connectorSelector ?? 2;
  }

  container.partData = data;

  container.noParent = false;

  container.legSlotFull = !data.hasLegSlot;

  container.mountSlotFull = !data.hasMountSlot;

  if (data.usesSlot == MOUNT_SLOT && system != 4) parent.mountSlotFull = true;
  else if (data.usesSlot == LEG_SLOT) {
    parent.legSlotFull = true;
  }

  container.legsNeeded = data.legsNeeded;

  container.legsLimit = data.legsLimit;

  if (parent.legsNeeded && !parent.legSlotFull)
    container.legsLimit = Math.min(
      parent.legsLimit - container.partData.length,
      container.legsLimit - container.partData.length
    );

  if (container.legsLimit <= 10 && !data.actsAsLegs && !parent.legSlotFull) {
    container.legsLimit = data.legsLimit;

    partsContainer.addChild(mpasPart(LEGS(), parent));

    if (data.rails)
      alert(
        "A leg kit was added automatically as it is needed by the rail kit."
      );
    else
      alert(
        "A leg kit was added automatically as your span is too long to be unsupported."
      );
  }

  if (parent.legSlotFull) resetChildLegCounter(parent);

  container.frameOffset =
    (data.frameOffset + parent.frameOffset + parent.partData.childFrameOffset) %
    4;

  if (parent.childFrameOffset != 0)
    container.rotationOffset = -90 * container.frameOffset;
  else container.rotationOffset = 0;

  container.partData.childFrameOffset = data.childFrameOffset;

  container.currentFrame = (currentFrame + container.frameOffset) % 4;

  container.parentPart = parent;

  container.rotation = container.rotationOffset;

  container.iZOrderMod = data.iZOrderMod[container.currentFrame];
  container.x =
    parent.x +
    parent.getChildByName("MOUNT").x -
    container.partData.connectorPoint[container.currentFrame].x;

  container.y =
    parent.y +
    parent.getChildByName("MOUNT").y -
    container.partData.connectorPoint[container.currentFrame].y;

  if (container.rotationOffset < 0) {
    container.x =
      parent.x +
      parent.getChildByName("MOUNT").x +
      container.partData.connectorPoint[container.currentFrame].x +
      container.partData.rotationOffsets[
        (container.rotationOffset / -90 + container.currentFrame) % 4
      ].x;

    container.y =
      parent.y +
      parent.getChildByName("MOUNT").y +
      container.partData.connectorPoint[container.currentFrame].y +
      container.partData.rotationOffsets[
        (container.rotationOffset / -90 + container.currentFrame) % 4
      ].y;
  }

  var sprite = new createjs.Sprite(data.spriteSheet);

  var spriteButtonHelper = new createjs.ButtonHelper(sprite);

  sprite.addEventListener("click", handleMPASPartClicked);

  sprite.addEventListener("mouseover", handleMpasMouseOver);

  sprite.addEventListener("mouseout", handleMpasMouseOut);

  sprite.name = container.name = id;

  id++;

  sprite.regX = data.spriteCenter.x;

  sprite.regY = data.spriteCenter.y;
  if (spriteCentreObj.isChange) {
    sprite.regX = spriteCentreObj.spriteCentre.x;
    sprite.regY = spriteCentreObj.spriteCentre.y;
  }

  container.addChild(sprite);

  var center = new createjs.Shape();

  center.name = "CENTER";

  center.graphics.beginFill(null).drawCircle(0, 0, 5);

  container.addChild(center);

  var f = new createjs.Shape();

  f.name = "MOUNT";

  f.graphics.beginFill(null).drawCircle(0, 0, 5);

  f.x = container.partData.mountPoint[container.currentFrame].x;

  f.y = container.partData.mountPoint[container.currentFrame].y;

  container.addChild(f);


  var p = new createjs.Shape();

  p.name = "CONNECTOR";

  p.graphics.beginFill(null).drawCircle(0, 0, 5);

  p.x = container.partData.connectorPoint[container.currentFrame].x;

  p.y = container.partData.connectorPoint[container.currentFrame].y;

  container.addChild(p);
  sprite.gotoAndStop(container.currentFrame);
  sprite.rotation = -camAngle - container.rotationOffset;

  parts.push(sprite.name);

  let skipIndexParent = parent?.partData?.connectorSelector ?? 0;

  let parentConnector = container.parentConnector;
  if (parent.getChildByName("openConnector_" + parentConnector)) {
    let openChild = parent.getChildByName("openConnector_" + parentConnector);
    //parent.removeChild(openChild);
    openChild.name = "closeConnector_" + parentConnector;
    openChild.visible = false;
    parent.availablePort.splice(
      parent.availablePort.indexOf(parentConnector),
      1
    );
  }

  if (data?.neighborPort && parent.getChildByName("openConnector_" + data.neighborPort)) {

    let openChild = parent.getChildByName("openConnector_" + data.neighborPort);
    //parent.removeChild(openChild);
    openChild.name = "closeConnector_" + data.neighborPort;
    openChild.visible = false;
    parent.availablePort.splice(
      parent.availablePort.indexOf(data.neighborPort),
      1
    );
  }

  container.availablePort = [];
  let skipIndex = data?.connectorSelector ?? 0;
  if (data?.frameHighlights?.length) {
    let frameHighLight = data.frameHighlights;
    if (getRotationType(data?.defaultName) == "rotate") {
      frameHighLight = [
        [
          [91, 273],
          [65, 288],
          [-32, 233],
          [-1, 218],
        ],
        [
          [97, 271],
          [123, 286],
          [211, 232],
          [185, 217],
        ],
        [
          [372, 1],
          [398, -14],
          [490, 41],
          [464, 56],
        ],
        [
          [4, 219],
          [-22, 204],
          [67, 150],
          [92, 165],
        ],

        [
          [181, 221],
          [207, 236],
          [295, 182],
          [269, 167],
        ],
        [
          [277, 166],
          [303, 181],
          [391, 127],
          [365, 112],
        ],
        [
          [368, 111],
          [394, 126],
          [482, 72],
          [456, 57],
        ],
        [
          [91, 161],
          [65, 151],
          [153, 97],
          [179, 112],
        ],
        [
          [190, 110],
          [164, 95],
          [253, 41],
          [279, 56],
        ],
        [
          [282, 55],
          [257, 40],
          [346, - 14],
          [372, 1]
        ],
      ];
      if (data.height == 90) {
        frameHighLight[2] = [
          [371, 109],
          [279, 54],
          [305, 39],
          [397, 94],
        ]
      }
      if (data.height == 60) {
        frameHighLight[2] = [
          [308, 42 + 106],
          [282, 57 + 106],
          [185, -2 + 106],
          [211, -13 + 106],
        ]
      }
    } else {
      if (data.height == 90) {
        frameHighLight[2] = [
          [314, 233],
          [288, 218],
          [383, 164],
          [402, 179],
        ]
      }
      if (data.height == 60) {
        frameHighLight[2] = [
          [211, 179],
          [186, 164],
          [281, 110],
          [300, 125],
        ]
      }
    }

    let rotationType =
      data?.rotationType ??
      parent.partData.usedCoordinates?.[container.parentConnector]?.parent ??
      2;

    if (parent.partData.ladder) {
      let connected = [0, 3, 2, 1];
      rotationType = data?.rotationType ?? connected[container.parentConnector];
      if (data.bridgeSpan && (data?.height != 30 && data?.rotationType != 2)) {

        switch (true) {
          case data?.rotationType == 3:
            rotationType = 1;
            break;
          case data.height == 60 && data?.rotationType == 6:
            rotationType = 4;
            break;
          case data.height == 90 && data?.rotationType == 6:
            rotationType = 5;
            break;
          case parent.partData?.side == 1 && [0].includes(rotationType):
            rotationType = 2;
            break;
          default:
            rotationType = data?.rotationType;
            break;
        }
      }
      else {
        switch (true) {
          case parent.partData?.side == 0 && [0, 2].includes(rotationType):
            rotationType = 2;
            break;
          case parent.partData?.side == 3 && [2].includes(rotationType):
          case parent.partData?.side == 2 && [2].includes(rotationType):
            rotationType = 0;
            break;
        }
      }
    }
    if (parent.partData.bridgeSpan && data.bridgeSpan) {
      if ([0, 2].includes(rotationType)) {

        switch (true) {
          case getRotationType(data.defaultName) == "default" && getRotationType(parent.partData.defaultName) == "default" && container.parentConnector == 2:
          case getRotationType(data.defaultName) == "default" && getRotationType(parent.partData.defaultName) == "rotate" && [1, 4, 5, 6].includes(parseInt(container.parentConnector)):
            rotationType = 0;
            break;
          case getRotationType(data.defaultName) == "rotate" && getRotationType(parent.partData.defaultName) == "default" && [1, 4, 5, 6].includes(parseInt(container.parentConnector)):
            rotationType = 2;
            break;
        }

      }
      else {

        if (data.height != 30) {
          switch (true) {
            case data.height == 60 && data?.rotationType == 6:
              rotationType = 4;
              break;
            case data.height == 90 && data?.rotationType == 6:
              rotationType = 5;
              break;
            default:
              rotationType = data?.rotationType;
              break;
          }

          if (getRotationType(parent.partData.defaultName) == "rotate" && [0, 2].includes(parentConnector)) {
            
            switch (true) {
              case parentConnector == 2 && rotationType == 3 && data.height != 120:
                rotationType = 1;
                break;
              case parentConnector == 0 && rotationType == 3 && data.height == 120:
                rotationType = 9;
                break;
              case parentConnector == 0 && rotationType == 4 && data.height != 120:
                rotationType = 7;
                break;
              case parentConnector == 0 && rotationType == 5 && data.height != 120:
                rotationType = 8;
                break;
              case parentConnector == 0 && rotationType == 4 && data.height == 120:
                rotationType = 8;
                break;
              case parentConnector == 0 && rotationType == 5 && data.height == 120:
                rotationType = 7;
                break;
              case parentConnector == 0 && rotationType == 6 && data.height == 120:
                rotationType = 3;
                break;
            

                case parentConnector == 2 && rotationType == 3 && data.height == 120:
                rotationType = 6;
                break;
                case parentConnector == 2 && rotationType == 4 && data.height == 120:
                  rotationType = 5;
                  break;
                case parentConnector == 2 && rotationType == 5 && data.height == 120:
                  rotationType = 4;
                  break;
                  case parentConnector == 2 && rotationType == 6 && data.height == 120:
                    rotationType = 1;
                    break;              
            }
          } else {
            let mpas = new availableSideForPlatform();
            rotationType = (mpas.sideUsed(rotationType, container.parentConnector, data.height, parent.partData.height));
          }
        }
      }
    }
    rotationType = Array.isArray(rotationType) ? rotationType : [rotationType];
    for (let i = 0; i <= frameHighLight.length - 1; i++) {

      if ((data.height == 90 && [6, 9].includes(i)))
        continue;
      if (data.height == 60 && [5, 6, 8, 9].includes(i))
        continue;
      if (
        rotationType.includes(i) == false
      ) {
        let spriteX = data.spriteCenter.x;
        let spriteY = data.spriteCenter.y;
        if (data.height == 90 && getRotationType(data.defaultName) == "rotate") {
          spriteY += 53;

        }
        if (data.height == 60 && getRotationType(data.defaultName) == "rotate") {
          spriteY += 106;

        }
        let fShape = new defaultMpasData().frameHighLight(
          frameHighLight[i],
          -spriteX,
          -spriteY
        );
        fShape.name = "openConnector_" + i;
        fShape.visible = false;
        container.addChild(fShape);
        container.availablePort.push(i);
      }
    }
  }

  updateDimensions(data.width, data.length, container.currentFrame);

  if (!container.partData.legs && !container.partData.rails) {
    SelectPartMenu(container);

    selectPartMenu.originPart = container;
  } else if (container.partData.rails) {
    selectPartMenu.originPart.partData.sideSelector = true;
    if (selectPartMenu.originPart.hasOwnProperty("railsId") == false) {
      selectPartMenu.originPart.railsId = [container.name];
    } else {
      selectPartMenu.originPart.railsId.push(container.name);
    }
    SelectPartMenu(selectPartMenu.originPart);

  }

  if (
    data.ladder &&
    data.name.indexOf("90") != -1 &&
    (system == 1 || system == 2)
  ) {
    showAddedTip();
  }
  return container;
}

function InitialPartMPAS(data) {
  bridgeHeight = 0;
  setBridgeHeight(data);
  var container = new createjs.Container();

  container.partData = data;

  container.noParent = true;

  container.frameOffset = 0;

  container.childFrameOffset = data.childFrameOffset;

  container.rotationOffset = 0;

  container.currentFrame = currentFrame;

  container.legSlotFull = !data.hasLegSlot;

  container.mountSlotFull = !data.hasMountSlot;

  container.zOrderMod = data.zOrderMod[container.currentFrame];

  container.iZOrderMod = data.iZOrderMod[container.currentFrame];

  container.legsLimit = data.legsLimit;

  container.legsNeeded = data.legsNeeded;

  container.x = 0;

  container.y = 0;

  var sprite = new createjs.Sprite(data.spriteSheet);

  var spriteButtonHelper = new createjs.ButtonHelper(sprite);

  sprite.addEventListener("click", handleMPASPartClicked);

  sprite.addEventListener("mouseover", handleMpasMouseOver);

  sprite.addEventListener("mouseout", handleMpasMouseOut);

  sprite.name = container.name = id;

  id++;

  sprite.regX = data.spriteCenter.x;

  sprite.regY = data.spriteCenter.y;

  container.addChild(sprite);

  var center = new createjs.Shape();

  center.name = "CENTER";

  center.graphics.beginFill(null).drawCircle(0, 0, 5);

  container.addChild(center);

  var f = new createjs.Shape();

  f.name = "MOUNT";

  f.graphics.beginFill(null).drawCircle(0, 0, 5);

  f.x = container.partData.mountPoint[container.currentFrame].x;

  f.y = container.partData.mountPoint[container.currentFrame].y;

  container.addChild(f);

  var p = new createjs.Shape();

  p.name = "CONNECTOR";

  p.graphics.beginFill(null).drawCircle(0, 0, 5);

  p.x = container.partData.connectorPoint[container.currentFrame].x;

  p.y = container.partData.connectorPoint[container.currentFrame].y;

  container.addChild(p);

  sprite.gotoAndStop(currentFrame);

  parts.push(sprite.name);

  length.push(data.length);

  iwidth = data.width;

  if (!data.legs) {
    SelectPartMenu(container);

    SelectPartMenu.originPart = container;
  }

  if (
    data.ladder &&
    data.name.indexOf("90") != -1 &&
    (system == 1 || system == 2 || system == 4)
  ) {
    showAddedTip();
  }

  return container;
}

function updateDimensions(pwidth, plength, frame) {
  switch (frame) {
    case 0:
      length.push(plength);

      if (pwidth > iwidth && width.length == 0) iwidth = pwidth;

      return;

    case 1:
      width.push(-plength);

      return;

    case 2:
      length.push(-plength);

      return;

    case 3:
      width.push(plength);

      return;
  }
}

function resetChildLegCounter(parent) {
  for (var i = 0; i < partsContainer.getNumChildren(); i++) {
    childPart = partsContainer.getChildAt(i);

    if (childPart.parentPart == parent && !childPart.legs) {
      childPart.legsLimit = childPart.partData.legsLimit;

      if (parent.legsNeeded && !parent.legSlotFull)
        childPart.legsLimit = Math.min(
          parent.legsLimit - childPart.partData.length,
          childPart.legsLimit - childPart.partData.length
        );

      if (!childPart.actsAsLegs) resetChildLegCounter(childPart);

      return;
    }
  }
}

// Event Handlers

function handleMPASPartClicked(event) {
  //var clicked = partsContainer.getChildByName(event.target.name);
  //if ((!clicked.mountSlotFull || !clicked.legSlotFull|| (!clicked.partData.hasMountSlot&&!clicked.partData.legs)) && !(hasLadderAsChild(clicked)))
  //  stage.addChild(SelectPartMenu(partsContainer.getChildByName(event.target.name)));
  //updateZOrder();
}

function handleMpasMouseOver(event) {
  // var target = partsContainer.getChildByName(event.target.name);
  // target.highlight.visible = true;
  // if(LAST_CLICKED_MAX_ACCESS_PART != target)
  //   toolTipText.text = "Click to select this part";
  //var target = partsContainer.getChildByName(event.target.name);
  //if ((!target.mountSlotFull || !target.legSlotFull || (!target.partData.hasMountSlot&&!target.partData.legs)) && !(hasLadderAsChild(target)))
  //  target.filters = [new createjs.ColorFilter(0.5,0.5,0.5,1, 192,64,0,0)];
  //target.cache(-target.partData.spriteCenter.x * 8, -target.partData.spriteCenter.y * 8, target.partData.spriteCenter.x * 16, target.partData.spriteCenter.y *16);
}

function handleMpasMouseOut(event) {
  //var target = partsContainer.getChildByName(event.target.name);
  //target.filters = [];
  //target.cache(-target.partData.spriteCenter.x * 8, -target.partData.spriteCenter.y * 8, target.partData.spriteCenter.x * 16, target.partData.spriteCenter.y *16);
}

function getConnectorPoint(
  parentConnector,
  currentName,
  parentHeight,
  currentHeight,
  parentCenter,
  currentCenter,
  parentName,
  rotationCord
) {
  let rotationType = getRotationType(currentName);
  let parentRotationType = getRotationType(parentName);

  if (currentHeight == 30) {
    rotationType = parentRotationType;
  }
  let coords = getCoordinates(
    parentHeight,
    parentConnector,
    rotationType,
    currentHeight,
    parentRotationType,
    rotationCord
  );
  let mpasData = new defaultMpasData();
  if (((parentHeight == 90) && parentRotationType == "rotate")) {
    coords = new createjs.Point(coords.x, coords.y + 53);
  }
  if (((parentHeight == 60) && parentRotationType == "rotate")) {

    coords = new createjs.Point(coords.x, coords.y + 106);
  }
  if (currentHeight == 90 && (rotationType == "rotate" && [0, 2].includes(parentConnector)) && parentRotationType == "default") {
    coords = new createjs.Point(coords.x, coords.y - 54);
  }
  if (currentHeight == 60 && (rotationType == "rotate" && [0, 2].includes(parentConnector)) && parentRotationType == "default") {
    coords = new createjs.Point(coords.x, coords.y - 108);
  }
  if (parentHeight == 120 && (rotationType == "rotate" &&  [2].includes(parentConnector)) && parentRotationType == "default") {
    coords = new createjs.Point(coords.x-278, coords.y - 161);
  }
  if (parentHeight == 60 && (rotationType == "rotate" &&  [2].includes(parentConnector)) && parentRotationType == "default") {
    coords = new createjs.Point(coords.x-92, coords.y - 55);
  }
  if (parentHeight == 90 && (rotationType == "rotate" &&  [2].includes(parentConnector)) && parentRotationType == "default") {
    coords = new createjs.Point(coords.x-188, coords.y - 108);
  }
  let conn = mpasData.getRotateCords([coords], currentCenter, parentCenter)[0];
  mpasData.getRotateCordsSpriteCenter(conn, currentCenter, parentCenter);
  
  return conn;
}

function getCoordinates(
  parentHeight,
  parentConnector,
  rotationType,
  currentHeight,
  parentRotationType,
  rotationCord
) {
  // alert(rotationType)
  /*let connectorArr = {
    30: [
      { default: new createjs.Point(93, 54), 120: new createjs.Point(372, 215) },
      { default: new createjs.Point(93, -54), 120: new createjs.Point(373, -54) },
      { default: new createjs.Point(-93, -54), 120: new createjs.Point(-93, -54) },
      { default: new createjs.Point(-93, 54), 120: new createjs.Point(-93, 215) }
    ],

  };*/
  let connectorArr = {
    0: {
      default: new createjs.Point(93, 54),
      rotate: new createjs.Point(93, -215),
      rotate_120: new createjs.Point(372, -215),
      rotate_90: new createjs.Point(277, -214),
      rotate_60: new createjs.Point(186, -215),
      default_120: new createjs.Point(372, 215),
      default_90: new createjs.Point(278, 161),
      default_60: new createjs.Point(184, 108),
    },
    1: {
      default: new createjs.Point(93, -54),
      rotate: new createjs.Point(-92, -214),
      rotate_120: new createjs.Point(373, -54),
      rotate_90: new createjs.Point(277, -54),
      rotate_60: new createjs.Point(183, -53),
      default_120: new createjs.Point(-91, -214),
      default_90: new createjs.Point(-92, -214),
      default_60: new createjs.Point(-93, -214),
    },
    2: {
      default: new createjs.Point(-93, -54),
      rotate: new createjs.Point(-371, 54),
      rotate_120: new createjs.Point(-373, 215),
      rotate_90: new createjs.Point(-279, 162),
      rotate_60: new createjs.Point(-185, 106),
      default_120: new createjs.Point(-372, -215),
      default_90: new createjs.Point(-280, -162),
      default_60: new createjs.Point(-186, -108),
    },
    3: {
      default: new createjs.Point(-93, 54),
      rotate: new createjs.Point(94, -107),
      rotate_120: new createjs.Point(-93, 215),
      rotate_90: new createjs.Point(-94, 160),
      rotate_60: new createjs.Point(-93, 109),
      default_120: new createjs.Point(354, 53),
      default_90: new createjs.Point(277, 1),
      default_60: new createjs.Point(186, -52),
    },

    4: {
      default: new createjs.Point(0, -108),
      rotate: new createjs.Point(-186, -161),
      rotate_120: new createjs.Point(280, -108),
      rotate_90: new createjs.Point(184, -108),
      rotate_60: new createjs.Point(90, -107),
      default_120: new createjs.Point(-185, -161),
      default_90: new createjs.Point(-184, -161),
      default_60: new createjs.Point(-186, -161),
    },
    5: {
      default: new createjs.Point(-93, -162),
      rotate: new createjs.Point(-279, -108),
      rotate_120: new createjs.Point(188, -162),
      rotate_90: new createjs.Point(94, -160),
      rotate_60: new createjs.Point(0, -158),
      default_120: new createjs.Point(-278, -107),
      default_90: new createjs.Point(-277, -108),
      default_60: new createjs.Point(-278, -107),
    },
    6: {
      default: new createjs.Point(-186, -215),
      rotate: new createjs.Point(-372, -55),
      rotate_120: new createjs.Point(95, -215),
      rotate_90: new createjs.Point(2, -213),
      rotate_60: new createjs.Point(-93, -212),
      default_120: new createjs.Point(-371, -53),
      default_90: new createjs.Point(-369, -54),
      default_60: new createjs.Point(-370, -53),
    },
    7: {
      default: new createjs.Point(-186, 0),
      rotate: new createjs.Point(0, -53),
      rotate_120: new createjs.Point(-187, 161),
      rotate_90: new createjs.Point(-186, 107),
      rotate_60: new createjs.Point(-186, 53),
      default_120: new createjs.Point(278, 107),
      default_90: new createjs.Point(184, 55),
      default_60: new createjs.Point(93, 1),
    },
    8: {
      default: new createjs.Point(-279, -54),
      rotate: new createjs.Point(-93, 0),
      rotate_120: new createjs.Point(-270, 107),
      // rotate_90: new createjs.Point(-185, 106),
      rotate_90: new createjs.Point(-275, 56),
      rotate_60: new createjs.Point(-279, 0),
      default_120: new createjs.Point(186, 161),
      default_90: new createjs.Point(0, 109),
      default_60: new createjs.Point(0, 54),
    },
    9: {
      default: new createjs.Point(-368, -104),
      rotate: new createjs.Point(-186, 54),
      rotate_120: new createjs.Point(-373, 53),
      // rotate_90: new createjs.Point(-275, 56),
      rotate_90: new createjs.Point(-370, 0),
      rotate_60: new createjs.Point(-372, -53),
      default_120: new createjs.Point(94, 215),
      default_90: new createjs.Point(-1, 162),
      default_60: new createjs.Point(-93, 107),
    },
    10: {
      default: new createjs.Point(-1, 106),
      rotate: new createjs.Point(189, -1),
    },
    11: {
      default: new createjs.Point(91, 158),

      rotate: new createjs.Point(279, -53),
    },
    12: {
      default: new createjs.Point(181, 211),

      rotate: new createjs.Point(372, -107)
    },
    13: {
      default: new createjs.Point(186, -1),
      rotate: new createjs.Point(0, -108),
    },
    14: {
      default: new createjs.Point(278, 54),
      rotate: new createjs.Point(92, -160),
    },
    15: {
      default: new createjs.Point(365, 104),
      rotate: new createjs.Point(186, -215),
    },
  };
  let currentCords = connectorArr[parentConnector];
  getChildPrefix = rotationType;
  getChild = rotationType + "_" + currentHeight;

  if (
    currentHeight != 30 &&
    ((rotationType == parentRotationType &&
      parentConnector != 0 &&
      rotationCord != 2 &&
      parentConnector != 2 &&
      rotationCord != 0) ||
      (rotationType != parentRotationType &&
        [0, 2].includes(parentConnector) &&
        [1, 3, 4, 5, 6, 7, 8, 9].includes(rotationCord)))
  ) {
    // if(parentRotationType =="rotate"){
    //   switch (parentConnector){
    //     case 0:
    //       parentConnector = 1;
    //       break;
    //   }
    // }
    let coords = getRotationConnector(
      parentConnector,
      rotationCord,
      currentHeight
    );

    if ([0, 2].includes(parentConnector)) {
      if (parentRotationType == "default") {
        let coords30 = {
          120: {
            6: new createjs.Point(370, 54),
            5: new createjs.Point(280, 106),
            4: new createjs.Point(187, 160),
            1: new createjs.Point(90, 212),
            9: new createjs.Point(181, -53),
            8: new createjs.Point(93, -1),
            7: new createjs.Point(0, 53),
            3: new createjs.Point(-95, 107),
          },
          90: {
            1: new createjs.Point(92, 161 + 53),
            4: new createjs.Point(188, 107 + 53),
            5: new createjs.Point(278, 54 + 53),
            3: new createjs.Point(93, -1),
            7: new createjs.Point(0, 0 + 53),
            6: new createjs.Point(268, -54 + 53),
            8: new createjs.Point(-95, 107),
          },
          60: {
            1: new createjs.Point(92, 108 + 106),
            4: new createjs.Point(187, 53 + 106),
            3: new createjs.Point(0, 53),
            7: new createjs.Point(-95, 107),
          }
        }
        currentCords = coords30?.[currentHeight]?.[coords] ?? connectorArr[coords][getChild];
      } else {
        let coordsRotate = {
          120: {
            6: new createjs.Point(90, -215),
            5: new createjs.Point(185, -160),
            4: new createjs.Point(275, -110),
            1: new createjs.Point(370, -55),
            9: new createjs.Point(-375, 54),
            8: new createjs.Point(-280, 110),
            7: new createjs.Point(-190, 160),
            3: new createjs.Point(-95, 214),
          },
          90: {
            1: new createjs.Point(90, -215),
            4: new createjs.Point(185, -160),
            5: new createjs.Point(275, -110),
            3: new createjs.Point(-375, 54),
            7: new createjs.Point(-280, 110),
            8: new createjs.Point(-190, 160),
          },
          60: {
            1: new createjs.Point(90, -215),
            4: new createjs.Point(185, -160),
            3: new createjs.Point(-375, 54),
            7: new createjs.Point(-280, 110),
          },
        }
        currentCords = coordsRotate?.[currentHeight]?.[coords] ?? connectorArr[coords][getChild];
        if (parentConnector == 2 && parentHeight == 90 && rotationType == "default") {
          currentCords = new createjs.Point(currentCords.x + 93, currentCords.y - 53)
        }
        if (parentConnector == 2 && parentHeight == 60 && rotationType == "default") {
          currentCords = new createjs.Point(currentCords.x + 186, currentCords.y - 106)
        }

      }
    }
    else {
      
      currentCords = connectorArr[coords][rotationType];

      if ((currentHeight == 90) && parentRotationType == "rotate" && rotationType == "rotate") {
        if (coords < 10) {
          currentCords = new createjs.Point(currentCords.x, currentCords.y + 106)
        }
        else {
          currentCords = new createjs.Point(currentCords.x, currentCords.y - 53)
        }
      }
      if ((currentHeight == 60) && parentRotationType == "rotate" && rotationType == "rotate") {
        if (coords < 10) {
          currentCords = new createjs.Point(currentCords.x, currentCords.y + 53)
        }
        else {
          currentCords = new createjs.Point(currentCords.x, currentCords.y - 106)
        }
      }
    }
    if (parentRotationType == "rotate" && rotationType == "rotate" && currentHeight == 120 && parentHeight != 30 && coords < 10) {

      currentCords = new createjs.Point(currentCords.x, currentCords.y + 161)
    }

  }
  else if (parentConnector == 2) {

    currentCords = (parentHeight != 30) ? currentCords[rotationType + "_" + parentHeight] : currentCords[parentRotationType];

    if (parentRotationType == "rotate" && rotationType == "rotate") {

      if (parentHeight == 120 || parentHeight == 60 || parentHeight == 90) {
        switch (parseInt(currentHeight)) {
          case 30:
            currentCords = new createjs.Point(currentCords.x, currentCords.y - 161);
            break;
          case 60:
            currentCords = new createjs.Point(currentCords.x, currentCords.y - 108);
            break;
          case 90:
            currentCords = new createjs.Point(currentCords.x, currentCords.y - 54);
            break;
        }
      }
    }
  }
  else if (currentCords?.hasOwnProperty(getChild)) {
    currentCords = currentCords[getChild];
    //alert(1, getChild);
  } else {

    if (currentCords.hasOwnProperty(currentHeight)) {
      //alert(2, currentHieght);
      currentCords = currentCords[currentHeight];
    } else if (currentCords.hasOwnProperty(getChildPrefix)) {
      currentCords = currentCords[getChildPrefix];
    } else {
      currentCords = currentCords["default"];
    }
  }

  return currentCords;
}

function getRotationType(currentName) {
  let rotationType = "default";
  switch (currentName) {
    case "default":
    case "c":
    case "defaultBack":
    case "cBack":
    case "r1Left":
    case "r2Left":
    case "l1Left":
    case "l2Left":
    case "r1Right":
    case "r2Right":
    case "l1Right":
    case "l2Right":
      rotationType = "default";
      break;
    case "r1":
    case "r2":
    case "l1":
    case "l2":
    case "l1Back":
    case "l2Back":
    case "r1Back":
    case "r2Back":
    case "defaultLeft":
    case "cLeft":
    case "defaultRight":
    case "cRight":
      rotationType = "rotate";
      break;
  }
  return rotationType;
}

function getRotationConnector(connector, defaultSide, currentHeight) {
  switch (true) {
    case (connector == 9 && defaultSide == 6 && currentHeight == 120):
    case (connector == 8 && defaultSide == 5 && currentHeight == 120):
    case (connector == 7 && defaultSide == 4):
    case (connector == 3 && defaultSide == 3):
    case (connector == 7 && defaultSide == 6 && currentHeight == 60):
    case (connector == 7 && defaultSide == 5 && currentHeight == 60):
    case (connector == 7 && defaultSide == 5 && currentHeight == 90):
    case (connector == 8 && defaultSide == 5 && currentHeight == 120):
    case (connector == 8 && defaultSide == 6 && currentHeight == 90):
      return 3;
    case (connector == 9 && defaultSide == 5 && currentHeight == 120):
    case (connector == 8 && defaultSide == 4):
    case (connector == 7 && defaultSide == 3):

    case (connector == 8 && defaultSide == 5 && currentHeight == 90):
    case (connector == 8 && defaultSide == 6 && currentHeight == 60):
    case (connector == 9 && defaultSide == 6 && currentHeight == 90):
    case (connector == 2 && defaultSide == 6 && currentHeight == 60):
    case (connector == 2 && defaultSide == 5 && currentHeight == 90):
    case (connector == 2 && defaultSide == 4 && currentHeight == 120):
    case (connector == 2 && defaultSide == 4 && currentHeight == 90):
      return 7;
    case (connector == 9 && defaultSide == 4):
    case (connector == 8 && defaultSide == 3):
    case (connector == 9 && defaultSide == 5 && currentHeight == 90):
    case (connector == 9 && defaultSide == 6 && currentHeight == 60):
    case (connector == 2 && defaultSide == 6 && currentHeight == 90):
    case (connector == 2 && defaultSide == 5 && currentHeight == 120):
      return 8;
    case (connector == 9 && defaultSide == 3):

    case (connector == 2 && defaultSide == 6):

      return 9;
    case (connector == 8 && defaultSide == 6 && currentHeight == 120):
    case (connector == 7 && defaultSide == 5 && currentHeight == 120):
    case (connector == 3 && defaultSide == 4 && currentHeight == 120):
    case (connector == 3 && defaultSide == 5 && currentHeight == 90):
    case (connector == 3 && defaultSide == 6 && currentHeight == 60):
    case (connector == 7 && defaultSide == 6 && currentHeight == 90):
    case (connector == 3 && defaultSide == 4 && currentHeight == 90):
      return 10;
    case (connector == 7 && defaultSide == 6 && currentHeight == 120):
    case (connector == 3 && defaultSide == 5 && currentHeight == 120):
    case (connector == 3 && defaultSide == 6 && currentHeight == 90):
      return 11;
    case connector == 3 && defaultSide == 6 && currentHeight == 120:
      return 12;
    case (connector == 5 && defaultSide == 3 && currentHeight == 120) ||
      (connector == 4 && defaultSide == 4 && currentHeight != 90) ||
      (connector == 1 && defaultSide == 5) ||
      (connector == 1 && defaultSide == 3 && currentHeight == 60) ||
      (connector == 4 && defaultSide == 3 && currentHeight == 90):
    case (connector == 1 && defaultSide == 4 && currentHeight == 90):
      return 13;
    case connector == 1 && defaultSide == 3 && currentHeight == 120:
      return 15;
    case (connector == 4 && defaultSide == 3 && currentHeight == 120) ||
      (connector == 1 && defaultSide == 4 && currentHeight != 90) ||
      (connector == 1 && defaultSide == 3 && currentHeight == 90):
      return 14;
    case (connector == 5 && defaultSide == 5) ||
      (connector == 4 && defaultSide == 6) ||
      (connector == 6 && defaultSide == 3 && currentHeight == 90):
    case (connector == 5 && defaultSide == 3 && currentHeight == 60):
    case connector == 0 && defaultSide == 6 && currentHeight == 60:
    case connector == 0 && defaultSide == 5 && currentHeight == 90:
    case connector == 2 && defaultSide == 4 && currentHeight == 90:
      return 4;
    case connector == 5 && defaultSide == 6:
    case (connector == 6 && defaultSide == 3 && currentHeight == 60):
    case connector == 0 && defaultSide == 6 && currentHeight == 90:
    case (connector == 6 && defaultSide == 4 && currentHeight == 90):
      return 5;

    case [0, 1, 4, 5, 6].includes(connector) && defaultSide == 3:
    case (connector == 4 && defaultSide == 4 && currentHeight == 90):
      return 1;

    case (connector == 5 && defaultSide == 4 && currentHeight != 90) ||
      (connector == 4 && defaultSide == 5) ||
      (connector == 1 && defaultSide == 6):
      return 1;
    case connector == 5 && defaultSide == 3 && currentHeight == 90:
      return 6;
    default:
      return defaultSide;
  }
}

function getLadderCoordinates(
  data,
  parentCenter,
  parentConnector,
  defaultName,
  parentHeight
) {

  let mpasData = new defaultMpasData();
  let rotateType = getRotationType(defaultName);
  let coords = {
    2: {
      0: {
        down: new createjs.Point(22, 125),
        up: new createjs.Point(22, 159),
      },
      1: {
        down: new createjs.Point(25, 61),
        up: new createjs.Point(16, 85),
      },
      2: {
        down: new createjs.Point(-98, 58),
        up: new createjs.Point(-98, 90),
      },
      3: {
        down: new createjs.Point(-96, 127),
        up: new createjs.Point(-100, 160),
      },
      4: {
        down: new createjs.Point(-71, 7),
        up: new createjs.Point(-67, 37),
      },
      5: {
        down: new createjs.Point(-165, -48),
        up: new createjs.Point(-161, -17),
      },
      6: {
        down: new createjs.Point(-262, -105),
        up: new createjs.Point(-260, -74),
      },
      7: {
        down: new createjs.Point(-158, 92),
        up: new createjs.Point(-184, 111),
      },
      8: {
        down: new createjs.Point(-275, 24),
        up: new createjs.Point(-283, 54),
      },
      9: {
        down: new createjs.Point(-385, -39),
        up: new createjs.Point(-385, -6),
      },
    },
    3: {
      0: {
        down: new createjs.Point(49, 130),
        up: new createjs.Point(49, 205),
      },
      1: {
        down: new createjs.Point(45, 58),
        up: new createjs.Point(37, 103),
      },
      2: {
        down: new createjs.Point(-99, 58),
        up: new createjs.Point(-92, 105),
      },
      3: {
        down: new createjs.Point(-109, 129),
        up: new createjs.Point(-99, 206),
      },
      4: {
        down: new createjs.Point(-41, 8),
        up: new createjs.Point(-43, 56),
      },
      5: {
        down: new createjs.Point(-141, -50),
        up: new createjs.Point(-145, -4),
      },
      6: {
        down: new createjs.Point(-239, -106),
        up: new createjs.Point(-228, -52),
      },
      7: {
        down: new createjs.Point(-192, 55),
        up: new createjs.Point(-198, 146),
      },
      8: {
        down: new createjs.Point(-281, 26),
        up: new createjs.Point(-291, 97),
      },
      9: {
        down: new createjs.Point(-385, -34),
        up: new createjs.Point(-392, 39),
      },
    },
    4: {
      0: {
        down: new createjs.Point(73, 142),
        up: new createjs.Point(74, 247),
      },
      1: {
        down: new createjs.Point(75, 62),
        up: new createjs.Point(66, 131),
      },
      2: {
        down: new createjs.Point(-98, 57),
        up: new createjs.Point(-91, 129),
      },
      3: {
        down: new createjs.Point(-98, 147),
        up: new createjs.Point(-93, 250),
      },
      4: {
        down: new createjs.Point(-16, 9),
        up: new createjs.Point(-21, 81),
      },
      5: {
        down: new createjs.Point(-113, -46),
        up: new createjs.Point(-112, 27),
      },
      6: {
        down: new createjs.Point(-218, -107),
        up: new createjs.Point(-204, -25),
      },
      7: {
        down: new createjs.Point(-198, 56),
        up: new createjs.Point(-193, 195),
      },
      8: {
        down: new createjs.Point(-298, 32),
        up: new createjs.Point(-290, 139),
      },
      9: {
        down: new createjs.Point(-386, -21),
        up: new createjs.Point(-388, 83),
      },
    },
    5: {
      0: {
        down: new createjs.Point(106, 156),
        up: new createjs.Point(107, 292),
      },
      1: {
        down: new createjs.Point(103, 61),
        up: new createjs.Point(92, 171),
      },
      2: {
        down: new createjs.Point(-88, 56),
        up: new createjs.Point(-93, 163),
      },
      3: {
        down: new createjs.Point(-95, 160),
        up: new createjs.Point(-93, 297),
      },
      4: {
        down: new createjs.Point(9, 8),
        up: new createjs.Point(0, 110),
      },
      5: {
        down: new createjs.Point(-85, -47),
        up: new createjs.Point(-86, 60),
      },
      6: {
        down: new createjs.Point(-183, -103),
        up: new createjs.Point(-180, 3),
      },
      7: {
        down: new createjs.Point(-169, 119),
        up: new createjs.Point(-196, 237),
      },
      8: {
        down: new createjs.Point(-280, 55),
        up: new createjs.Point(-291, 183),
      },
      9: {
        down: new createjs.Point(-391, -7),
        up: new createjs.Point(-384, 130),
      },
    },
    6: {
      0: {
        down: new createjs.Point(126, 166),
        up: new createjs.Point(124, 339),
      },
      1: {
        down: new createjs.Point(126, 61),
        up: new createjs.Point(118, 196),
      },
      2: {
        down: new createjs.Point(-103, 61),
        up: new createjs.Point(-95, 195),
      },
      3: {
        down: new createjs.Point(-103, 166),
        up: new createjs.Point(-92, 342),
      },
      4: {
        down: new createjs.Point(38, 11),
        up: new createjs.Point(20, 145),
      },
      5: {
        down: new createjs.Point(-57, -45),
        up: new createjs.Point(-61, 79),
      },
      6: {
        down: new createjs.Point(-152, -99),
        up: new createjs.Point(-152, 28),
      },
      7: {
        down: new createjs.Point(-179, 122),
        up: new createjs.Point(-191, 285),
      },
      8: {
        down: new createjs.Point(-284, 60),
        up: new createjs.Point(-286, 232),
      },
      9: {
        down: new createjs.Point(-388, 0),
        up: new createjs.Point(-378, 179),
      },
    },
    7: {
      0: {
        down: new createjs.Point(154, 215),
        up: new createjs.Point(153, 381),
      },
      1: {
        down: new createjs.Point(154, 61),
        up: new createjs.Point(149, 250),
      },
      2: {
        down: new createjs.Point(-98, 57),
        up: new createjs.Point(-93, 247),
      },
      3: {
        down: new createjs.Point(-98, 215),
        up: new createjs.Point(-97, 384),
      },
      4: {
        down: new createjs.Point(65, 8),
        up: new createjs.Point(35, 187),
      },
      5: {
        down: new createjs.Point(-32, -44),
        up: new createjs.Point(-61, 124),
      },
      6: {
        down: new createjs.Point(-131, -101),
        up: new createjs.Point(-152, 78),
      },
      7: {
        down: new createjs.Point(-171, 175),
        up: new createjs.Point(-181, 336),
      },
      8: {
        down: new createjs.Point(-281, 112),
        up: new createjs.Point(-280, 279),
      },
      9: {
        down: new createjs.Point(-391, 50),
        up: new createjs.Point(-379, 222),
      },
    },
    8: {
      0: {
        down: new createjs.Point(182, 197),
        up: new createjs.Point(183, 423),
      },
      1: {
        down: new createjs.Point(172, 57),
        up: new createjs.Point(174, 254),
      },
      2: {
        down: new createjs.Point(-104, 61),
        up: new createjs.Point(-95, 247),
      },
      3: {
        down: new createjs.Point(-101, 197),
        up: new createjs.Point(-100, 423),
      },
      4: {
        down: new createjs.Point(80, 6),
        up: new createjs.Point(79, 192),
      },
      5: {
        down: new createjs.Point(-7, -40),
        up: new createjs.Point(-9, 141),
      },
      6: {
        down: new createjs.Point(-104, -100),
        up: new createjs.Point(-101, 88),
      },
      7: {
        down: new createjs.Point(-179, 154),
        up: new createjs.Point(-188, 375),
      },
      8: {
        down: new createjs.Point(-275, 97),
        up: new createjs.Point(-281, 323),
      },
      9: {
        down: new createjs.Point(-374, 44),
        up: new createjs.Point(-376, 268),
      },
    },
    9: {
      0: {
        down: new createjs.Point(200, 233),
        up: new createjs.Point(203, 470),
      },
      1: {
        down: new createjs.Point(205, 63),
        up: new createjs.Point(194, 295),
      },
      2: {
        down: new createjs.Point(-100, 58),
        up: new createjs.Point(-95, 295),
      },
      3: {
        down: new createjs.Point(-100, 233),
        up: new createjs.Point(-104, 470),
      },
      4: {
        down: new createjs.Point(113, 8),
        up: new createjs.Point(112, 244),
      },
      5: {
        down: new createjs.Point(22, -46),
        up: new createjs.Point(0, 176),
      },
      6: {
        down: new createjs.Point(-75, -101),
        up: new createjs.Point(-108, 86),
      },
      7: {
        down: new createjs.Point(-181, 182),
        up: new createjs.Point(-177, 429),
      },
      8: {
        down: new createjs.Point(285, -120),
        up: new createjs.Point(275, 362),
      },
      9: {
        down: new createjs.Point(-381, 65),
        up: new createjs.Point(-374, 312),
      },
    },
  };
  if (rotateType == "rotate") {
    coords = {
      9: {
        3: {
          down: new createjs.Point(373, -223),
          up: new createjs.Point(376, -474),
        },
        9: {
          down: new createjs.Point(83, -223),
          up: new createjs.Point(77, -469),
        },
        1: {
          down: new createjs.Point(-201, 101),
          up: new createjs.Point(-194, -131),
        },
        6: {
          down: new createjs.Point(382, -63),
          up: new createjs.Point(-34, -801),
        },
        8: {
          down: new createjs.Point(-7, -175),
          up: new createjs.Point(-19, -417),
        },
        7: {
          down: new createjs.Point(-99, -131),
          up: new createjs.Point(-113, -362),
        },
        0: {
          down: new createjs.Point(-214, -66),
          up: new createjs.Point(-208, -308),
        },
        5: {
          down: new createjs.Point(296, -11),
          up: new createjs.Point(-140, -40),
        },
        4: {
          down: new createjs.Point(196, 45),
          up: new createjs.Point(168, -175),
        },
        2: {
          down: new createjs.Point(92, 106),
          up: new createjs.Point(95, -141),
        },
      },

      8: {
        3: {
          down: new createjs.Point(379, -198),
          up: new createjs.Point(377, -429),
        },
        9: {
          down: new createjs.Point(110, -205),
          up: new createjs.Point(112, -433),
        },
        1: {
          down: new createjs.Point(-179, 101),
          up: new createjs.Point(-173, -98),
        },
        6: {
          down: new createjs.Point(383, -63),
          up: new createjs.Point(389, -270),
        },
        8: {
          down: new createjs.Point(22, -153),
          up: new createjs.Point(17, -378),
        },
        7: {
          down: new createjs.Point(-66, -105),
          up: new createjs.Point(-76, -326),
        },
        0: {
          down: new createjs.Point(-157, -51),
          up: new createjs.Point(-173, -270),
        },
        5: {
          down: new createjs.Point(291, -10),
          up: new createjs.Point(250, -173),
        },
        4: {
          down: new createjs.Point(198, 45),
          up: new createjs.Point(168, -145),
        },
        2: {
          down: new createjs.Point(101, 101),
          up: new createjs.Point(92, -98),
        },
      },

      7: {
        3: {
          down: new createjs.Point(375, -215),
          up: new createjs.Point(370, -388),
        },
        9: {
          down: new createjs.Point(157, -171),
          up: new createjs.Point(137, -388),
        },
        1: {
          down: new createjs.Point(-150, 104),
          up: new createjs.Point(-143, -84),
        },
        6: {
          down: new createjs.Point(398, -45),
          up: new createjs.Point(380, -280),
        },
        8: {
          down: new createjs.Point(52, -169),
          up: new createjs.Point(43, -333),
        },
        7: {
          down: new createjs.Point(-67, -101),
          up: new createjs.Point(-65, -279),
        },
        0: {
          down: new createjs.Point(-152, -54),
          up: new createjs.Point(-158, -218),
        },
        5: {
          down: new createjs.Point(266, 8),
          up: new createjs.Point(251, -176),
        },
        4: {
          down: new createjs.Point(194, 45),
          up: new createjs.Point(173, -131),
        },
        2: {
          down: new createjs.Point(94, 104),
          up: new createjs.Point(93, -86),
        },
      },
      6: {
        3: {
          down: new createjs.Point(376, -167),
          up: new createjs.Point(376, -340),
        },
        9: {
          down: new createjs.Point(156, -169),
          up: new createjs.Point(162, -344),
        },
        1: {
          down: new createjs.Point(-127, 98),
          up: new createjs.Point(-115, -20),
        },
        6: {
          down: new createjs.Point(381, -63),
          up: new createjs.Point(380, -188),
        },
        8: {
          down: new createjs.Point(60, -113),
          up: new createjs.Point(75, -293),
        },
        7: {
          down: new createjs.Point(-24, -65),
          up: new createjs.Point(-27, -232),
        },
        0: {
          down: new createjs.Point(-121, -8),
          up: new createjs.Point(-121, -180),
        },
        5: {
          down: new createjs.Point(291, -9),
          up: new createjs.Point(288, -139),
        },
        4: {
          down: new createjs.Point(195, 44),
          up: new createjs.Point(188, -78),
        },
        2: {
          down: new createjs.Point(100, 100),
          up: new createjs.Point(100, -28),
        },
      },
      5: {
        3: {
          down: new createjs.Point(380, -156),
          up: new createjs.Point(388, -288),
        },
        9: {
          down: new createjs.Point(189, -156),
          up: new createjs.Point(188, -302),
        },
        1: {
          down: new createjs.Point(-103, 101),
          up: new createjs.Point(-80, 10),
        },
        6: {
          down: new createjs.Point(377, -60),
          up: new createjs.Point(385, -173),
        },
        8: {
          down: new createjs.Point(94, -105),
          up: new createjs.Point(93, -247),
        },
        7: {
          down: new createjs.Point(0, -52),
          up: new createjs.Point(-2, -192),
        },
        0: {
          down: new createjs.Point(-106, 5),
          up: new createjs.Point(-107, -133),
        },
        5: {
          down: new createjs.Point(284, -9),
          up: new createjs.Point(290, -120),
        },
        4: {
          down: new createjs.Point(189, 45),
          up: new createjs.Point(188, -57),
        },
        2: {
          down: new createjs.Point(94, 100),
          up: new createjs.Point(93, 0),
        },
      },
      4: {
        3: {
          down: new createjs.Point(379, -144),
          up: new createjs.Point(377, -250),
        },
        9: {
          down: new createjs.Point(212, -144),
          up: new createjs.Point(213, -252),
        },
        1: {
          down: new createjs.Point(-60, 104),
          up: new createjs.Point(-69, 28),
        },
        6: {
          down: new createjs.Point(383, -64),
          up: new createjs.Point(378, -137),
        },
        8: {
          down: new createjs.Point(124, -98),
          up: new createjs.Point(120, -199),
        },
        7: {
          down: new createjs.Point(50, -44),
          up: new createjs.Point(26, -145),
        },
        0: {
          down: new createjs.Point(-70, 20),
          up: new createjs.Point(-74, -85),
        },
        5: {
          down: new createjs.Point(286, -7),
          up: new createjs.Point(284, -81),
        },
        4: {
          down: new createjs.Point(193, 47),
          up: new createjs.Point(191, -28),
        },
        2: {
          down: new createjs.Point(100, 100),
          up: new createjs.Point(101, 16),
        },
      },
      3: {
        3: {
          down: new createjs.Point(373, -132),
          up: new createjs.Point(375, -205),
        },
        9: {
          down: new createjs.Point(232, -132),
          up: new createjs.Point(239, -209),
        },
        1: {
          down: new createjs.Point(-53, 99),
          up: new createjs.Point(-45, 56),
        },
        6: {
          down: new createjs.Point(380, -62),
          up: new createjs.Point(357, -107),
        },
        8: {
          down: new createjs.Point(141, -77),
          up: new createjs.Point(142, -156),
        },
        7: {
          down: new createjs.Point(49, -26),
          up: new createjs.Point(46, -98),
        },
        0: {
          down: new createjs.Point(-20, 10),
          up: new createjs.Point(-51, -43),
        },
        5: {
          down: new createjs.Point(289, -10),
          up: new createjs.Point(286, -57),
        },
        4: {
          down: new createjs.Point(195, 46),
          up: new createjs.Point(182, 5),
        },
        2: {
          down: new createjs.Point(100, 100),
          up: new createjs.Point(94, 56),
        },
      },
      2: {
        3: {
          down: new createjs.Point(374, -127),
          up: new createjs.Point(197, -50),
        },
        9: {
          down: new createjs.Point(257, -127),
          up: new createjs.Point(260, -161),
        },
        1: {
          down: new createjs.Point(-23, 100),
          up: new createjs.Point(-26, 71),
        },
        6: {
          down: new createjs.Point(380, -62),
          up: new createjs.Point(388, -94),
        },
        8: {
          down: new createjs.Point(159, -72),
          up: new createjs.Point(166, -107),
        },
        7: {
          down: new createjs.Point(60, -14),
          up: new createjs.Point(68, -51),
        },
        0: {
          down: new createjs.Point(-30, 40),
          up: new createjs.Point(-28, 5),
        },
        5: {
          down: new createjs.Point(286, -7),
          up: new createjs.Point(300, -44),
        },
        4: {
          down: new createjs.Point(194, 48),
          up: new createjs.Point(200, 13),
        },
        2: {
          down: new createjs.Point(100, 100),
          up: new createjs.Point(95, 75),
        },
      },
    };
  }

  let coordConnect = coords[data.configLength];
  if (parentConnector > 3) {
    coordConnect = coordConnect[parentConnector];
  }
  else {
    coordConnect = coordConnect[data?.side ?? 0];
  }
  if (data.isDown) {
    coordConnect = coordConnect["down"];
  } else {
    coordConnect = coordConnect["up"];
  }
  if (rotateType == "rotate") {
    coordConnect = (new createjs.Point(-(coordConnect.x), -(coordConnect.y)));
  }
  let conn = mpasData.getRotateCords(
    [coordConnect],
    data.spriteCenter,
    parentCenter
  )[0];

  if (parentConnector == 2 && parentHeight == 60 && rotateType == "default") {
    conn = new createjs.Point(conn.x - 95, conn.y - 52)
  }
  if (parentConnector == 2 && parentHeight == 120 && rotateType == "default") {
    conn = new createjs.Point(conn.x - 275, conn.y - 163)
  }
  if (parentConnector == 2 && parentHeight == 90 && rotateType == "default") {
    conn = new createjs.Point(conn.x - 185, conn.y - 108)
  }
  if (parentConnector == 2 && parentHeight == 90 && rotateType == "rotate") {
    conn = new createjs.Point(conn.x + 80, conn.y - 60)
  }
  if (parentConnector == 2 && parentHeight == 60 && rotateType == "rotate") {
    conn = new createjs.Point(conn.x + 170, conn.y - 110)
  }
  return conn;
}

function ladderToPlatform(data, parent) {
  let rotationType = getRotationType(data?.defaultName ?? "default");
  let laderRotaionType = parentRotation(parent);
  let coords;
  let parentRotationType = ((laderRotaionType.rotationType == "default" && [0, 2].includes(laderRotaionType.connector)) || (laderRotaionType.rotationType == "rotate" && [0, 2].includes(laderRotaionType.connector) == false)) ? "default" : "rotate";
  //getConnectorPoint(parent?.partData?.connectorSelector, data.defaultName, parent?.partData?.height, data.height, parent?.partData?.spriteCenter, data.spriteCenter, parent?.partData?.defaultName ?? "default", data?.rotationType ?? parent?.partData?.connectorSelector);
  if([1,3].includes(parent?.partData?.side) && rotationType != parentRotationType &&  data.height!=30){
    coords = getCoordinates(
      30,
      parent?.partData?.connectorSelector,
      "default",
      data.height,
      "default",
      data?.rotationType ?? parent?.partData?.connectorSelector
    );
  }
  else{
    coords = getCoordinates(
      30,
      parent?.partData?.connectorSelector,
      rotationType,
      data.height,
      parentRotationType,
      data?.rotationType ?? parent?.partData?.connectorSelector
    );
  }
  if (parentRotationType == rotationType && rotationType == "default") {
    if (parent.partData.side == 2) {
      coords = new createjs.Point(coords.x + 185, coords.y + 109);
    } else {
      coords = new createjs.Point(coords.x - 185, coords.y - 109);
    }
  }
  else if (parentRotationType == rotationType && rotationType == "rotate") {
    if (parent.partData.side == 3) {

      switch (parseInt(data.height)) {

        case 60:
          coords = new createjs.Point(coords.x + 180, coords.y - 110);
          break;
        case 90:
          coords = new createjs.Point(coords.x + 185, coords.y - 105);
          break;
        case 120:
          coords = new createjs.Point(coords.x + 180, coords.y - 110);
          break;
      }
    }
  }
  else if (parentRotationType == "default" && rotationType == "rotate") {

    if (parent.partData.side == 0) {
      coords = new createjs.Point(coords.x - 185, coords.y - 109);
      switch (parseInt(data.height)) {
        case 60:
          coords = new createjs.Point(coords.x, coords.y - 106);
          break;
        case 90:
          coords = new createjs.Point(coords.x, coords.y - 53);
          break;
      }

    } else {
      coords = new createjs.Point(coords.x + 185, coords.y + 109);
      switch (parseInt(data.height)) {
        case 60:
          coords = new createjs.Point(coords.x, coords.y - 106);
          break;
        case 90:
          coords = new createjs.Point(coords.x, coords.y - 53);
          break;
      }
    }

  }
  else if (parentRotationType == "rotate" && rotationType === "default") {
    console.log(coords, rotationType)
    if (parent.partData.side == 3) {
      coords = new createjs.Point(coords.x + 180, coords.y - 110);
      // switch (parseInt(data.height)) {
      //   case 30:
      //     coords = new createjs.Point(coords.x + 180, coords.y - 110);
      //     break;
      // }
    }

  }


  let mpasData = new defaultMpasData();
  let conn = mpasData.getRotateCords([coords], data.spriteCenter, parent?.partData?.spriteCenter)[0];

  return conn;
}
