// Select Part Menu

var selectPartMenu;
var originalPart;
var lastPartAdded;
let lastClickMpasSide;
let bridgeHeight = 0;
function SelectPartMenu(part) {
  refreshParts();
  selectPartMenu = new createjs.Container();
  selectPartMenu.originPart = part;
  originalPart = part;
  if (
    part.partData.bridgeSpan &&
    part.partData.sku !== "MPASP30" &&
    part.isOld
  ) {
    part.partData.isPlatformSelector = false;
    part.partData.sideSelector = true;
  } else if (
    part.partData.bridgeSpan &&
    part.partData.sku !== "MPASP30" &&
    !part.isOld
  ) {
    part.partData.isPlatformSelector = true;
    part.partData.sideSelector = false;
  }
  selectPartMenu.name = "SELECT_PART_MENU";
  if (partsMenuContainer.getChildByName("PART_BUTTONS_CONTAINER")) {
    partsMenuContainer.removeChild(
      partsMenuContainer.getChildByName("PART_BUTTONS_CONTAINER")
    );
  }

  var partButtonsContainer = new createjs.Container();
  partButtonsContainer.name = "PART_BUTTONS_CONTAINER";
  stage.getChildByName("PARTS_MENU_CONTAINER").addChild(partButtonsContainer);
  if (part?.partData?.sideSelector && system == 4) {
    addSideButtons(part, partButtonsContainer);
  } else {
    addPartButtons(part, partButtonsContainer);
  }
  if (
    (!part.mountSlotFull ||
      part.partData.rails ||
      (part.partData.actsAsLegs && !part.partData.turnpiece)) &&
    part.noParent == false
  ){
    addRemoveButton();
  }
    

  if (partButtonsContainer.getNumChildren() > 0) {
    if (part?.partData?.isPlatformSelector && system == 4) {
      //rotateMpasplateform();
      addNextButton();
      partsMenuContainerText.text = "Choose Platform connecting area";
    } else if (part?.partData?.sideSelector && system == 4) {
      //alert("side selector")
      partsMenuContainerText.text = "Choose next part mounting side";
    } else {
      partsMenuContainerText.text = "Select a part to add";
    }
  } else {
    partsMenuContainerText.text = "";
  }

  return selectPartMenu;
}

function addRemoveButton() {
  if(!partsMenuContainer.getChildByName("REMOVE_BUTTON"))
  {
    var removeButton = new createjs.Container();
    removeButton.x = 0;
    removeButton.y = 640;
    removeButton.name = "REMOVE_BUTTON";

    partsMenuContainer.addChild(removeButton);

    var removeButtonShape = new createjs.Shape();
    removeButtonShape.graphics
      .beginFill("#ff9e35")
      .beginStroke("#e17a0f")
      .drawRoundRect(0, 0, 260, 60, 5);

    removeButton.addChild(removeButtonShape);

    var removeButtonText = new createjs.Text(
      "Remove Last Part",
      "20px sans-serif",
      "#FFF"
    );
    removeButtonText.textAlign = "center";
    removeButtonText.x = 130;
    removeButtonText.y = 20;

    removeButton.addChild(removeButtonText);

    var removeButtonHelper = new createjs.ButtonHelper(removeButton);
    removeButton.addEventListener("click", handleRemoveClicked);
  }
}

function addNextButton() {
  if (
    stage
      .getChildByName("PARTS_MENU_CONTAINER")
      .getChildByName("NEXT_BUTTON") == null
  ) {
    var nextButton = new createjs.Container();
    nextButton.x = 0;
    nextButton.y = 570;
    nextButton.name = "NEXT_BUTTON";

    partsMenuContainer.addChild(nextButton);

    var nextButtonShape = new createjs.Shape();
    nextButtonShape.graphics
      .beginFill("#ff9e35")
      .beginStroke("#e17a0f")
      .drawRoundRect(0, 0, 260, 60, 5);

    nextButton.addChild(nextButtonShape);

    var nextButtonText = new createjs.Text("NEXT", "18px sans-serif", "#FFF");
    nextButtonText.textAlign = "center";
    nextButtonText.x = 130;
    nextButtonText.y = 20;

    nextButton.addChild(nextButtonText);

    var nextButtonHelper = new createjs.ButtonHelper(nextButton);
    nextButton.addEventListener("click", handleNextClicked);
  }
}

function handleNextClicked(event) {
  stage.getChildByName("PARTS_MENU_CONTAINER").removeChild(event.target.parent);
  if (partsMenuContainer.getChildByName("PART_BUTTONS_CONTAINER")) {
    partsMenuContainer.removeChild(
      partsMenuContainer.getChildByName("PART_BUTTONS_CONTAINER")
    );
  }

  var partButtonsContainer = new createjs.Container();
  partButtonsContainer.name = "PART_BUTTONS_CONTAINER";
  stage.getChildByName("PARTS_MENU_CONTAINER").addChild(partButtonsContainer);
  selectPartMenu.originPart.partData.isPlatformSelector = false;
  addSideButtons(selectPartMenu.originPart, partButtonsContainer);
}
function hasLadderAsChild(part) {
  for (var i = 0; i < partsContainer.getNumChildren(); i++) {
    childPart = partsContainer.getChildAt(i);
    if (childPart.parentPart == part && childPart.partData.ladder) {
      return true;
    }
  }
  return false;
}

function addPartButtons(part, selectPartMenu, sideParts = null) {
  
  var x = (y = 0);
  let connectors = sideParts ?? part.partData.connectableParts;
  let availableSide = new availableSideForPlatform();
  for (var i = 0; i < connectors.length; i++) {
    let newPart;
    if (
      connectors[i].split("_")[0] == "MPASGR60" ||
      connectors[i].split("_")[0] == "MPASGR60N"
    ) {
     
      newPart = PARTS[connectors[i].split("_")[0]];
      newPart.name1 = `rail with ${connectors[i].split("_")[1]} port`;
      newPart.neighborPort = parseInt(connectors[i].split("_")[2]);
    } else {
      newPart = PARTS[connectors[i]];
    }
    
    if (
      (newPart.usesSlot == MOUNT_SLOT && part.mountSlotFull && system!=4) ||
      (newPart.usesSlot == LEG_SLOT && part.legSlotFull) ||
      (newPart.ladder &&
        (part.legSlotFull &&
        !part.partData.turnPiece) &&
        system != 4) ||
      (part.mountSlotFull && newPart.legs && hasLadderAsChild(part))
    )
      continue;
    
    var partButton = new createjs.Container();
    partButton.part = newPart;
    partButton.x = x * 125 + 10;
    partButton.y = y * 120 + 20;
    selectPartMenu.addChild(partButton);

    var partButtonShape = new createjs.Shape();
    let fontMpasBold = "";
    if (
      (part.partData.name === newPart.name ||
        (part.partData.name === '120"L Platform' &&
          newPart.name === "Center")) &&
      part.partData?.isPlatformSelector &&
      system == 4
    ) {
      partButtonShape.graphics
        .setStrokeStyle(3)
        .beginFill("#FFF")
        .beginStroke("#e17a0f")
        .drawRoundRect(0, 0, 100, 90, 5);
      fontMpasBold = " bold ";
    } else {
      partButtonShape.graphics
        .beginFill("#FFF")
        .beginStroke("#e17a0f")
        .drawRoundRect(0, 0, 100, 90, 5);
    }

    partButton.addChild(partButtonShape);

    var partButtonText = new createjs.Text(
      connectors[i].split("_")[0] == "MPASGR60" ? newPart.name1 : newPart.name,
      fontMpasBold + "12px sans-serif",
      "#444"
    );
    partButtonText.textAlign = "center";
    partButtonText.x = 50;
    partButtonText.y = 92;
    partButton.addChild(partButtonText);

    var partImg = new createjs.Sprite(
      newPart.spriteSheetButton
        ? newPart.spriteSheetButton
        : newPart.spriteSheet
    );
    partImg.gotoAndStop(
      part.currentFrame +
        part.partData.childFrameOffset +
        (newPart.frameOffset % 4)
    );
    partImg.regX = newPart.spriteCenterButton
      ? newPart.spriteCenterButton.x
      : newPart.spriteCenter.x;
    partImg.regY = newPart.spriteCenterButton
      ? newPart.spriteCenterButton.y
      : newPart.spriteCenter.y;
    partImg.scaleX = partImg.scaleY = 0.2;
    partImg.x = 50;
    partImg.y = 35;
    partButton.addChild(partImg);

    selectPartMenu.addChild(partButton);

    var partButtonHelper = new createjs.ButtonHelper(partButton);
    partButton.addEventListener("click", handlePartSelected);

    x++;
    if (x == 2) {
      x = 0;
      y++;
    }
  }
}

function addSideButtons(part, selectPartMenu) {
  var x = (y = 0);
  part.availablePort.sort();
  for (var i = 0; i < part.availablePort.length; i++) {
    var partButton = new createjs.Container();
    partButton.connectorSelector = part.availablePort[i];
    partButton.x = x * 125 + 10;
    partButton.y = y * 120 + 20;
    selectPartMenu.addChild(partButton);
    var partButtonShape = new createjs.Shape();
    partButtonShape.graphics
      .beginFill("#fff")
      .beginStroke("#e17a0f")
      .drawRoundRect(0, 0, 100, 90, 5);
    var partButtonText = new createjs.Text(
      part.partData.usedCoordinates[part.availablePort[i]].name,
      "14px sans-serif",
      "#444"
    );
    partButtonText.textAlign = "center";
    partButtonText.x = 50;
    partButtonText.y = 42;
    partButton.addChild(partButtonShape);
    partButton.addChild(partButtonText);
    selectPartMenu.addChild(partButton);

    var partButtonHelper = new createjs.ButtonHelper(partButton);
    partButton.addEventListener("click", handleSideSelected);
    partButton.addEventListener("mouseover", handleSideMouseover);
    partButton.addEventListener("mouseout", handleSideMouseout);

    x++;
    if (x == 2) {
      x = 0;
      y++;
    }
  }
}

function rotateMpasplateform(data) {
  var parent = selectPartMenu.originPart.parentPart;
  selectPartMenu.originPart.parentPart.mountSlotFull = false;
  partsContainer.removeChild(
    partsContainer.getChildByName(selectPartMenu.originPart.name)
  );
  parts.splice(parts.indexOf(selectPartMenu.originPart.name), 1);
  selectPartMenu = new createjs.Container();
  selectPartMenu.originPart = parent;
  originalPart = parent;
  // SelectPartMenu(parent);
  // partsMenuContainerText.text = "Select a part to add";
  // partsMenuContainer.removeChild(partsMenuContainer.getChildByName("REMOVE_BUTTON"));

  // alert("rotateMpasplateform End");
}

// Event Handlers

function handleRemoveClicked(event) {
  if (selectPartMenu.originPart.railsId) {
    for (let partName of selectPartMenu.originPart.railsId) {
      let part = partsContainer.getChildByName(partName);
      parts.splice(parts.indexOf(partName), 1);
      partsContainer.removeChild(part);
    }
  }
  if (selectPartMenu.originPart.legSlotFull) {
    for (var i = 0; i < partsContainer.getNumChildren(); i++) {
      part = partsContainer.getChildAt(i);
      if (part.parentPart == selectPartMenu.originPart) {
        parts.splice(parts.indexOf(part.name), 1);
        partsContainer.removeChild(part);
        break;
      }
    }
  }
  if (
    stage.getChildByName("PARTS_MENU_CONTAINER").getChildByName("NEXT_BUTTON")
  ) {
    let nextButton = stage
      .getChildByName("PARTS_MENU_CONTAINER")
      .getChildByName("NEXT_BUTTON");
    stage.getChildByName("PARTS_MENU_CONTAINER").removeChild(nextButton);
  }
  decreaseBridgeHeight(selectPartMenu.originPart.partData);
  var parent = selectPartMenu.originPart?.parentPart ;

  if (
    parent.getChildByName(
      "closeConnector_" + selectPartMenu.originPart.parentConnector
    )
  ) {
    openChild = parent.getChildByName(
      "closeConnector_" + selectPartMenu.originPart.parentConnector
    );
    openChild.name =
      "openConnector_" + selectPartMenu.originPart.parentConnector;
    parent.availablePort.push(selectPartMenu.originPart.parentConnector);
    openChild.visible = false;
  }
  selectPartMenu.originPart.parentPart.mountSlotFull = false;
  partsContainer.removeChild(
    partsContainer.getChildByName(selectPartMenu.originPart.name)
  );
  parts.splice(parts.indexOf(selectPartMenu.originPart.name), 1);
  if (partsContainer.getNumChildren() == 1) {

    stage.getChildByName("FINISH_BUTTON").getChildByName("finishText").text =
      (system!=4)?"Complete":"Submit For Dimensional\ndrawings";
  }

  SelectPartMenu(parent);

  partsMenuContainerText.text = "Select a part to add";
  if(partsContainer.children.length == 1){
    let removeButton = partsMenuContainer.getChildByName("REMOVE_BUTTON");
    partsMenuContainer.removeChild(removeButton);
  }
  else{
    addRemoveButton();
  }
  updateZOrder();
  angularUpdate(parts);
}

function handlePartSelected(event) {
  partsMenuContainer.removeChild(
    partsMenuContainer.getChildByName("scrollbar")
  );
  if (selectPartMenu.originPart?.partData?.isPlatformSelector && system == 4) {
    rotateMpasplateform(event.target);
  }
  if (system == 4) {
    if (
      selectPartMenu.originPart.partData.bridgeSpan &&
      selectPartMenu.originPart.partData.sku !== "MPASP30"
    ) {
      //selectPartMenu.originPart.isPlatformSelector = false;
      selectPartMenu.originPart.isOld = true;
    }
    newPart = mpasPart(event.target.parent.part, selectPartMenu.originPart);
  } else {
    newPart = Part(event.target.parent.part, selectPartMenu.originPart);
  }
  partsContainer.addChild(newPart);
  if (
    selectPartMenu.originPart.parentPart.partData.bridgeSpan &&
    selectPartMenu.originPart.parentPart.partData.sku !== "MPASP30"
  ) {
    selectPartMenu.originPart.parentPart.partData.isPlatformSelector = true;
  }

  if (!newPart.partData.legs) {
    newPart.iZOrderMod = getZOrderNew(newPart);
  } else newPart.iZOrderMod += partsContainer.getChildByName(newPart.name).y;
  updateZOrder();
  angularUpdate(parts);
}

function handleSideSelected(event) {
  lastClickMpasSide = event.target;
  selectPartMenu.originPart.partData.connectorSelector =
    event.target.parent.connectorSelector;
  // selectPartMenu.originPart.partData.sideSelector = false;
  // selectPartMenu.originPart.partData.isPlatformSelector = false;
  let side = selectPartMenu.originPart.getChildByName(
    "openConnector_" + event.target.parent.connectorSelector
  );
  side.visible = true;
  partsMenuContainer.removeChild(
    partsMenuContainer.getChildByName("PART_BUTTONS_CONTAINER")
  );
  partsMenuContainerText.text = "Select a part to add";
  var partButtonsContainer = new createjs.Container();
  partButtonsContainer.name = "PART_BUTTONS_CONTAINER";
  stage.getChildByName("PARTS_MENU_CONTAINER").addChild(partButtonsContainer);
  let connectableSideParts = setPlatformConnectable(
    selectPartMenu.originPart.partData.usedCoordinates[
      event.target.parent.connectorSelector
    ].parent
  );
  let selector = selectPartMenu.originPart.partData.connectorSelector;
  connectableSideParts = [
    "MPASGR30",
    ...availabilityNeighborsPort(
      selector,
      selectPartMenu.originPart.availablePort
    ),
    ...connectableSideParts,
  ];
  addPartButtons(
    selectPartMenu.originPart,
    partButtonsContainer,
    connectableSideParts
  );
  if (partButtonsContainer.getNumChildren() > 10)
    DrawScrollBar(partButtonsContainer);
}

function handleSideMouseover(event) {
  selectPartMenu.originPart.partData.connectorSelector =
    event.target.parent.connectorSelector;
  let side = selectPartMenu.originPart.getChildByName(
    "openConnector_" + event.target.parent.connectorSelector
  );
  side.visible = true;
}
function handleSideMouseout(event) {
  let point = event.target;
  if (lastClickMpasSide == point) {
    return;
  } else {
    selectPartMenu.originPart.partData.connectorSelector =
      event.target.parent.connectorSelector;
    let side = selectPartMenu.originPart.getChildByName(
      "openConnector_" + event.target.parent.connectorSelector
    );
    side.visible = false;
  }
}

function setPlatformConnectable(side) {
  //alert(side);
  let nextPlatformSide = "";
  let connectableArr = [];
  let maxHeightBar = 8,
    minHeightBar = 1;
  let heightBar = (bridgeHeight / 10)+1;
  switch (side) {
    case 0:
      nextPlatformSide = "Front";
      connectableArr = [
        "MPASP30H" + heightBar,
        "MPASP60H" + heightBar,
        "MPASP90H" + heightBar,
        "MPASP120H" + heightBar,
      ];
      break;
    case 1:
    case 4:
    case 5:
    case 6:
      nextPlatformSide = "Left";
      connectableArr = [
        "MPASP30H" + heightBar,
        "MPASP60H" + heightBar + nextPlatformSide,
        "MPASP90H" + heightBar + nextPlatformSide,
        "MPASP120H" + heightBar + nextPlatformSide,
      ];
      break;
    case 2:
      nextPlatformSide = "Back";
      connectableArr = [
        "MPASP30H" + heightBar,
        "MPASP60H" + heightBar + nextPlatformSide,
        "MPASP90H" + heightBar + nextPlatformSide,
        "MPASP120H" + heightBar + nextPlatformSide,
      ];
      break;
    case 3:
    case 7:
    case 8:
    case 9:
      nextPlatformSide = "Right";
      connectableArr = [
        "MPASP30H" + heightBar,
        "MPASP60H" + heightBar + nextPlatformSide,
        "MPASP90H" + heightBar + nextPlatformSide,
        "MPASP120H" + heightBar + nextPlatformSide,
      ];
      break;
  }
  let connectStair = [];
  let bar = heightBar-1;
  for (let i = minHeightBar; i <= maxHeightBar; i++) {
    if (i > bar) {
      i + bar <= maxHeightBar
        ? connectStair.push("MPASSW" + (i + 1) + nextPlatformSide[0] + "U")
        : null;
    } else {
      bar - i >= 0
        ? connectStair.push("MPASSW" + (i + 1) + nextPlatformSide[0] + "D")
        : null;
      i + bar <= maxHeightBar
        ? connectStair.push("MPASSW" + (i + 1) + nextPlatformSide[0] + "U")
        : null;
    }
  }
  return [...connectableArr, ...connectStair];
}

function setBridgeHeight(data) {
  if (data.ladder) {
    bridgeHeight += data.length;
  }
}
function decreaseBridgeHeight(data) {
  if (data.ladder) {
    // if(data.lenght != 10){
    //   bridgeHeight -= data.length;
    // }else{
    //   bridgeHeight -= 20;
    // }
    bridgeHeight -= data.length;
  }
}

function availabilityNeighborsPort(connectorSelector, availableSide) {
  let portAvailable = [];
  let neighborConfig = {
    1: [4],
    4: [5, 1],
    5: [6, 4],
    6: [5],
    3: [7],
    7: [8, 3],
    8: [9, 7],
    9: [8],
  };
  let sideName = {
    1: "left",
    4: "left1",
    5: "left2",
    6: "left3",
    3: "right",
    7: "right1",
    8: "right2",
    9: "right3",
  };
  if (neighborConfig.hasOwnProperty(connectorSelector)) {
    for (let side of neighborConfig[connectorSelector]) {
      if (availableSide.includes(side)) {
        let name =
          neighborConfig[connectorSelector].indexOf(side) == 1
            ? "MPASGR60"
            : "MPASGR60N";
        portAvailable.push(`${name}_${sideName[side]}_${side}`);
      }
    }
  }
  return portAvailable;
}

function getZOrderNew(newPart) {
  let zOrder = partsContainer.getChildByName(newPart.name).y;
  let rotation = parentRotation(newPart.parentPart);

  switch (true) {
    case newPart?.partData?.rails &&
      [0, 3, 7, 8, 9].includes(newPart?.parentConnector) &&
      rotation.rotationType == "default":
    case newPart?.partData?.rails &&
      [2].includes(newPart?.parentConnector) &&
      rotation.rotationType == "default":
    case (newPart?.partData?.bridgeSpan || newPart?.partData?.ladder) &&
      newPart.parentPart.partData.bridgeSpan &&
      rotation.rotationType == "default" &&
      [0, 3, 7, 8, 9].includes(newPart?.parentConnector):
    case (newPart?.partData?.bridgeSpan || newPart?.partData?.ladder) &&
      newPart.parentPart.partData.bridgeSpan &&
      rotation.rotationType == "rotate" &&
      [2, 3, 7, 8, 9].includes(newPart?.parentConnector):
    case newPart.partData.bridgeSpan && newPart.parentPart.noParent:
    case newPart?.partData?.bridgeSpan &&
      newPart.parentPart.partData.ladder &&
      rotation.rotationType == "default" &&
      [0, 3, 7, 8, 9].includes(rotation?.connector):
    case newPart?.partData?.bridgeSpan &&
      newPart.parentPart.partData.ladder &&
      rotation.rotationType == "rotate" &&
      [2, 3, 7, 8, 9].includes(rotation?.connector):
      zOrder = newPart.parentPart.iZOrderMod - 1;
      break;
    //case -1

    case newPart?.partData?.rails &&
      [1, 4, 5, 6].includes(newPart?.parentConnector):
    case newPart?.partData?.rails &&
      [0].includes(newPart?.parentConnector) &&
      rotation.rotationType == "rotate":
    case (newPart?.partData?.bridgeSpan || newPart?.partData?.ladder) &&
      newPart.parentPart.partData.bridgeSpan &&
      rotation.rotationType == "default" &&
      [2, 1, 4, 5, 6].includes(newPart?.parentConnector):
    case (newPart?.partData?.bridgeSpan || newPart?.partData?.ladder) &&
      newPart.parentPart.partData.bridgeSpan &&
      rotation.rotationType == "rotate" &&
      [0, 1, 4, 5, 6].includes(newPart?.parentConnector):
      zOrder = newPart.parentPart.iZOrderMod + 2;
      break;
    //case +2

    case newPart?.partData?.rails &&
      [2, 3, 7, 8, 9].includes(newPart?.parentConnector) &&
      rotation.rotationType == "rotate":

    case newPart?.partData?.bridgeSpan &&
      newPart.parentPart.partData.ladder &&
      rotation.rotationType == "default" &&
      [2, 1, 4, 5, 6].includes(rotation?.connector):
    case newPart?.partData?.bridgeSpan &&
      newPart.parentPart.partData.ladder &&
      rotation.rotationType == "rotate" &&
      [0, 1, 4, 5, 6].includes(rotation?.connector):
      zOrder = newPart.parentPart.iZOrderMod + 1;
      break;
    //case +1
  }
  
  return zOrder;
}

function parentRotation(data) {
  if (data.partData.bridgeSpan) {
    return { rotationType: getRotationType(data.partData?.defaultName) };
  } else if (data.partData.ladder) {
    return {
      rotationType: getRotationType(
        data?.parentPart?.partData?.defaultName ?? "default"
      ),
      connector: data?.parentConnector ?? 0,
    };
  }
}
