var maxTopDownView;

var MTDFACTOR = 1.5;
function MaxTopDownView(printView)
{
  toolTipText.visible = false;
  if(!printView)
    printView = false;

  maxTopDownView = new createjs.Container();
  maxTopDownViewParts = new createjs.Container();

  var topDownBackgroundShape = new createjs.Shape();
  if(printView)
    topDownBackgroundShape.graphics.beginFill("rgba(40,40,40,1)").drawRect(0,0,960,800);
  else
    topDownBackgroundShape.graphics.beginFill("rgba(40,40,40,0.8").drawRect(0,0,960,800);
  maxTopDownView.addChild(topDownBackgroundShape);

  var topDownBackgroundShapeButtonHelper = new createjs.ButtonHelper(topDownBackgroundShape);
  topDownBackgroundShape.addEventListener("click", maxbackgroundClicked);

  //The Grid
  for(var x=0; x<=1920; x+=(12*MTDFACTOR))
  {
    var line = new createjs.Shape();
    line.graphics.beginStroke("rgba(255,255,255,0.2)");
    line.graphics.moveTo(x,0);
    line.graphics.lineTo(x, 1600);
    maxTopDownViewParts.addChild(line);
  }
  for(var y=0; y<=1600; y+=(12*MTDFACTOR))
  {
    var line = new createjs.Shape();
    line.graphics.beginStroke("rgba(255,255,255,0.2)");
    line.graphics.moveTo(0,y);
    line.graphics.lineTo(1920, y);
    maxTopDownViewParts.addChild(line);
  }
  maxTopDownView.addChild(maxTopDownViewParts);

  //Key
  var keyText = new createjs.Text("KEY", "16px sans-serif", "#FFFFFF");
  keyText.textAlign = "center";
  keyText.x = 860;
  keyText.y = 10;
  maxTopDownView.addChild(keyText);

  var ladderShape = new createjs.Shape();
  ladderShape.x = 770;
  ladderShape.y = 30;
  ladderShape.graphics.beginFill("rgba(255,192,0,0.8)").beginStroke("#000000").drawRect(0,0,15,15);
  maxTopDownView.addChild(ladderShape);

  var ladderText = new createjs.Text("LADDER", "16px sans-serif", "#FFFFFF");
  ladderText.textAlign = "left";
  ladderText.y = 30;
  ladderText.x = 795;
  maxTopDownView.addChild(ladderText);

  var spanShape = new createjs.Shape();
  spanShape.x = 770;
  spanShape.y = 50;
  spanShape.graphics.beginFill("rgba(192,192,192,0.8)").beginStroke("#000000").drawRect(0,0,15,15);
  maxTopDownView.addChild(spanShape);

  var spanText = new createjs.Text("36\"x36\" PLATFORM", "16px sans-serif", "#FFFFFF");
  spanText.textAlign = "left";
  spanText.y = 50;
  spanText.x = 795;
  maxTopDownView.addChild(spanText);

  var legsShape = new createjs.Shape();
  legsShape.graphics.beginStroke("#FF2020").setStrokeStyle(4,2);
  legsShape.graphics.moveTo(777, 70);
  legsShape.graphics.lineTo(777, 85);
  maxTopDownView.addChild(legsShape);

  var legsText = new createjs.Text("LEG KIT", "16px sans-serif", "#FFFFFF");
  legsText.y = 70;
  legsText.x = 795;
  maxTopDownView.addChild(legsText);

  if(!printView)
  {
    var instructionText = new createjs.Text("Click Anywhere to Close", "16px sans-serif", "#FFFFFF");
    instructionText.textAlign = "center";
    instructionText.x = 480;
    instructionText.y = 760;
    maxTopDownView.addChild(instructionText);
  }

  var scaleText = new createjs.Text("Each grid line represents 1\'", "16px sans-serif", "#FFFFFF");
  scaleText.textAlign = "left";
  scaleText.x = 10;
  scaleText.y = 10;
  maxTopDownView.addChild(scaleText);

  var point = new createjs.Point(477,414);
  var direction = 0;
  defaultPartsOrder();
  var lastPart;
  var lastContainer;
  var openSpan = 0;
  var openSpanComponents = new Array();
  var length = 0;
  var startPoint = point;

  for(var i=0; i<partsContainer.getNumChildren(); i++)
  {
    part = partsContainer.getChildAt(i);
    if (part.partData.rails || part.partData.legs)
      continue;
    var container = new createjs.Container();
    var rect = new createjs.Shape();
    container.partCoordinates = part.coordinates;
    container.partData = part.partData;
    container.partRotation = part.noParent ? 0 : part.mountPoint.rotOffset;
    container.noParent = part.noParent;
    container.name = part.name;
    rect.graphics.beginFill(maxFillColor(part.partData)).beginStroke("#000000").drawRect(-((MTDFACTOR * part.partData.width)/2), 0, (MTDFACTOR * part.partData.width), -(MTDFACTOR * part.partData.length));
    container.addChild(rect);
    var upPoint = new createjs.Shape();
    upPoint.x = 0;
    upPoint.y = -MTDFACTOR*part.partData.length;
    upPoint.name = "UP";
    container.addChild(upPoint);
    var leftPoint = new createjs.Shape();
    leftPoint.x = -MTDFACTOR*0.5*part.partData.width;
    leftPoint.y = -MTDFACTOR*part.partData.length*0.5;
    leftPoint.name = "LEFT";
    container.addChild(leftPoint);
    var rightPoint = new createjs.Shape();
    rightPoint.x = MTDFACTOR*0.5*part.partData.width;
    rightPoint.y = -MTDFACTOR*part.partData.length*0.5;
    rightPoint.name = "RIGHT";
    container.addChild(rightPoint);
    var downPoint = new createjs.Shape();
    downPoint.x = 0;
    downPoint.y = 0;
    downPoint.name = "DOWN";
    container.addChild(downPoint);
    if(part.noParent){
      container.x = 397;
      container.y = 450;
    }
    else {
      switch (part.mountPoint.rotOffset)
      {
        case 0:
          container.x = maxTopDownViewParts.getChildByName(part.parentPart.name).x + maxTopDownViewParts.getChildByName(part.parentPart.name).getChildByName("UP").x;
          container.y = maxTopDownViewParts.getChildByName(part.parentPart.name).y + maxTopDownViewParts.getChildByName(part.parentPart.name).getChildByName("UP").y;
          break;
        case -90:
          container.rotation = -90;
          container.x = maxTopDownViewParts.getChildByName(part.parentPart.name).x + maxTopDownViewParts.getChildByName(part.parentPart.name).getChildByName("LEFT").x;
          container.y = maxTopDownViewParts.getChildByName(part.parentPart.name).y + maxTopDownViewParts.getChildByName(part.parentPart.name).getChildByName("LEFT").y;
          break;
        case 180:
          container.rotation = 180;
          container.x = maxTopDownViewParts.getChildByName(part.parentPart.name).x + maxTopDownViewParts.getChildByName(part.parentPart.name).getChildByName("DOWN").x;
          container.y = maxTopDownViewParts.getChildByName(part.parentPart.name).y + maxTopDownViewParts.getChildByName(part.parentPart.name).getChildByName("DOWN").y;
          break;
        case 90:
          container.rotation = 90;
          container.x = maxTopDownViewParts.getChildByName(part.parentPart.name).x + maxTopDownViewParts.getChildByName(part.parentPart.name).getChildByName("RIGHT").x;
          container.y = maxTopDownViewParts.getChildByName(part.parentPart.name).y + maxTopDownViewParts.getChildByName(part.parentPart.name).getChildByName("RIGHT").y;
          break;
        default:
          break;
      }
    }
    if(part.partData.platform){
      container.rotation = 0;
      if(part.parentPart.partData.platform){
        switch (part.mountPoint.rotOffset){
          case 0:
            break;
          case -90:
            container.x -= rightPoint.x;
            container.y -= rightPoint.y;
            break;
          case 180:
            container.x -= upPoint.x;
            container.y -= upPoint.y;
            break;
          case 90:
            container.x -= leftPoint.x;
            container.y -= leftPoint.y;
            break;
          default:
            break;
        }
      }
      else {
        var TD_Parent = maxTopDownViewParts.getChildByName(part.parentPart.name);
        switch(TD_Parent.rotation){
          case 0:
            break;
          case -90:
            container.y -= TD_Parent.getChildByName("UP").y;
            container.x += TD_Parent.getChildByName("UP").y;
            container.x -= rightPoint.x;
            container.y -= rightPoint.y;
            break;
          case 180:
            container.y -= TD_Parent.getChildByName("UP").y;
            container.y -= TD_Parent.getChildByName("UP").y;
            container.x -= upPoint.x;
            container.y -= upPoint.y;
            break;
          case 90:
            container.y -= TD_Parent.getChildByName("UP").y;
            container.x -= TD_Parent.getChildByName("UP").y;
            container.x -= leftPoint.x;
            container.y -= leftPoint.y;
            break;
        }
      }
    }
    else {
      var lengthString = Math.floor(part.partData.length/12)+"\' " +(part.partData.length%12)+"\"L\n   x   \n" + Math.floor(part.partData.width/12)+"\' "+(part.partData.width%12)+"\"W";
      var dimText = new createjs.Text(lengthString, "8px sans-serif", "#fff");
      dimText.textAlign = "center";
      dimText.y = upPoint.y;
      if(container.rotation == 180){
        dimText.rotation = 180;
        dimText.y += 20;
      }
      //container.addChild(dimText);
    }
    length += part.partData.length;
    maxTopDownViewParts.addChild(container);
  }
  for(var x=0;x<40;x++){
    for(var y=0;y<40; y++){
      if(MAP[x][y][2]!=0){
        for(var p=0; p<maxTopDownViewParts.getNumChildren();p++){
          if(maxTopDownViewParts.getChildAt(p).partCoordinates && ( (maxTopDownViewParts.getChildAt(p).partCoordinates.x == x && maxTopDownViewParts.getChildAt(p).partCoordinates.y == y) || pointInPart(maxTopDownViewParts.getChildAt(p),x,y))){
            var legPart = maxTopDownViewParts.getChildAt(p);
            var legKitLine = new createjs.Shape();
            legKitLine.PRIORITY = 3;
            legKitLine.graphics.beginStroke("#FF2020").setStrokeStyle(6,2);
            if(legPart.partData.platform){
              switch(MAP[x][y][2]){
                case 1:
                  var ly = legPart.y + legPart.getChildByName("UP").y;
                  var lx = legPart.x + legPart.getChildByName("UP").x;
                  legKitLine.graphics.moveTo(lx-18*MTDFACTOR, ly);
                  legKitLine.graphics.lineTo(lx+18*MTDFACTOR, ly);
                  break;
                case 2:
                  var ly = legPart.y + legPart.getChildByName("RIGHT").y;
                  var lx = legPart.x + legPart.getChildByName("RIGHT").x;
                  legKitLine.graphics.moveTo(lx, ly-18*MTDFACTOR);
                  legKitLine.graphics.lineTo(lx, ly+18*MTDFACTOR);
                  break;
                case 3:
                  var ly = legPart.y + legPart.getChildByName("DOWN").y;
                  var lx = legPart.x + legPart.getChildByName("DOWN").x;
                  legKitLine.graphics.moveTo(lx-18*MTDFACTOR, ly);
                  legKitLine.graphics.lineTo(lx+18*MTDFACTOR, ly);
                  break;
                case 4:
                  var ly = legPart.y + legPart.getChildByName("LEFT").y;
                  var lx = legPart.x + legPart.getChildByName("LEFT").x;
                  legKitLine.graphics.moveTo(lx, ly-18*MTDFACTOR);
                  legKitLine.graphics.lineTo(lx, ly+18*MTDFACTOR);
                  break;
              }
              maxTopDownViewParts.addChild(legKitLine);
            }
            else {
              if(MAP[x][y][3] == 0){
                var ly;
                var lx;
                legKitLine.rotation = -legPart.rotation;
                switch(MAP[x][y][2]){
                  case 1:
                    if(legPart.partData.heightMod > 0 || MAP[x][y] != 0){
                       ly = legPart.getChildByName("UP").y;
                       lx = legPart.getChildByName("UP").x;
                    }
                    else {
                       ly = legPart.getChildByName("DOWN").y;
                       lx = legPart.getChildByName("DOWN").x;
                    }
                    legKitLine.graphics.moveTo(lx-18*MTDFACTOR, ly);
                    legKitLine.graphics.lineTo(lx+18*MTDFACTOR, ly);
                    break;
                  case 2:
                    if(legPart.partData.heightMod > 0 || MAP[x][y] != 0){
                     ly = legPart.getChildByName("UP").y;
                     lx = legPart.getChildByName("UP").x;
                    }
                    else{
                       ly = legPart.y + legPart.getChildByName("DOWN").y;
                       lx = legPart.x + legPart.getChildByName("DOWN").x;
                    }
                    legKitLine.graphics.moveTo(-ly, lx-18*MTDFACTOR);
                    legKitLine.graphics.lineTo(-ly, lx+18*MTDFACTOR);
                    break;
                  case 3:
                  if(legPart.partData.heightMod > 0 || MAP[x][y] != 0){
                     ly = legPart.getChildByName("UP").y;
                     lx = legPart.getChildByName("UP").x;
                    }
                    else{
                     ly = legPart.y + legPart.getChildByName("DOWN").y;
                     lx = legPart.x + legPart.getChildByName("DOWN").x;
                   }
                    legKitLine.graphics.moveTo(lx-18*MTDFACTOR, ly);
                    legKitLine.graphics.lineTo(lx+18*MTDFACTOR, ly);
                    break;
                  case 4:
                  if(legPart.partData.heightMod > 0 || MAP[x][y] != 0){
                     ly = legPart.getChildByName("UP").y;
                     lx = legPart.getChildByName("UP").x;
                    }
                    else{
                     ly = legPart.y + legPart.getChildByName("DOWN").y;
                     lx = legPart.x + legPart.getChildByName("DOWN").x;
                   }
                    legKitLine.graphics.moveTo(ly, lx-18*MTDFACTOR);
                    legKitLine.graphics.lineTo(ly, lx+18*MTDFACTOR);
                    break;
                }
                legPart.addChild(legKitLine);
              }
              else {
                legKitLine.rotation = -legPart.rotation;
                switch(MAP[x][y][2]){
                  case 1:
                    var ly = legPart.getChildByName("DOWN").y;
                    var lx = legPart.getChildByName("DOWN").x;
                    legKitLine.graphics.moveTo(lx-18*MTDFACTOR, ly);
                    legKitLine.graphics.lineTo(lx+18*MTDFACTOR, ly);
                    break;
                  case 2:
                    var ly = legPart.getChildByName("DOWN").y;
                    var lx = legPart.getChildByName("DOWN").x;
                    legKitLine.graphics.moveTo(lx, ly-18*MTDFACTOR);
                    legKitLine.graphics.lineTo(lx, ly+18*MTDFACTOR);
                    break;
                  case 3:
                    var ly = legPart.getChildByName("DOWN").y;
                    var lx = legPart.getChildByName("DOWN").x;
                    legKitLine.graphics.moveTo(lx-18*MTDFACTOR, ly);
                    legKitLine.graphics.lineTo(lx+18*MTDFACTOR, ly);
                    break;
                  case 4:
                    var ly = legPart.getChildByName("DOWN").y;
                    var lx = legPart.getChildByName("DOWN").x;
                    legKitLine.graphics.moveTo(lx, ly-18*MTDFACTOR);
                    legKitLine.graphics.lineTo(lx, ly+18*MTDFACTOR);
                    break;
                }
                legPart.addChild(legKitLine);
              }
            }
          }
        }
      }
    }
  }
  var ymax = 0;
  var xmax = 0;
  var ystart = 40;
  var yend = 0;
  var xstart = 40;
  var xend = 0;
  for(var x=0;x<40;x++){
    for(var y=0;y<40;y++) {
      if(MAP[x][y][1] != "E"){
        if(y < ystart)
          ystart = y;
        if(y > yend)
        yend = y;
      }
    }
  }
  for(var y=0;y<40;y++){
    for(var x=0;x<40;x++) {
      if(MAP[x][y][1] != "E"){
        if(x < xstart)
          xstart = x;
        if(x > xend)
        xend = x;
      }
    }
  }
  var yc = 0;
  var xc = 0;
  var ymaxr = 0;
  var xmaxr = 0;
  for(var x=0;x<40;x++){
    yc = 0;
    for(var y=0;y<40;y++) {
      if(MAP[x][y][1] != "E"){
        yc+=MAP[x][y][4].y
      }
    }
    if(yc > ymaxr)
      ymaxr = yc;
  }
  for(var y=0;y<40;y++){
    xc = 0;
    for(var x=0;x<40;x++) {
      if(MAP[x][y][1] != "E"){
        xc+=MAP[x][y][4].x
      }
    }
    if (xc > xmaxr)
      xmaxr = xc;
  }
  xmax = xend - xstart + 1;
  ymax = yend - ystart + 1;
  var yLine = new createjs.Container();
  yLine.x = (335 - 36*(20-xstart)*MTDFACTOR) ;
  yLine.y = (450 - 36*(21-ystart)*MTDFACTOR) + (36*(ymax)*MTDFACTOR);
  maxTopDownViewParts.addChild(yLine);
  var yLineShape = new createjs.Shape();
  yLineShape.graphics.beginStroke("#FFF").moveTo(0,0).lineTo(0,(-(ymaxr)*MTDFACTOR));
  yLine.addChild(yLineShape);
  var yLineText = new createjs.Text(Math.floor(ymaxr/12)+"\' "+ymaxr%12+"\"", "16px sans-serif", "#FFFFFF");
  yLine.addChild(yLineText);
  yLineText.y = -40;
  yLineText.x = -75;
  var xLine = new createjs.Container();
  xLine.x = (352 - 36*(20-xstart)*MTDFACTOR) ;
  xLine.y = (455 - 36*(21-ystart)*MTDFACTOR) + (36*(ymax)*MTDFACTOR);
  maxTopDownViewParts.addChild(xLine);
  var xLineShape = new createjs.Shape();
  xLineShape.graphics.beginStroke("#FFF").moveTo(0,0).lineTo(xmaxr*MTDFACTOR,0);
  xLine.addChild(xLineShape);
  var xLineText = new createjs.Text(Math.floor(xmaxr/12)+"\' "+xmaxr%12+"\"", "16px sans-serif", "#FFFFFF");
  xLine.addChild(xLineText);
  updateZOrder();
  maxSortElements();
  maxTopDownViewParts.scaleX = maxTopDownViewParts.scaleY = 1.25;
  return maxTopDownView;
}

function maxFillColor(data)
{
  if(data.ladder)
    return "rgba(255,192,64,0.8)"
  else
    return "rgba(192,192,192,0.8)"
}

function pointInPart(part,x,y){
  if(part.partData.platform)
    return false;
  switch (part.partRotation)
      {
        case 0:
          if(part.partCoordinates.x == x && y <= part.partCoordinates.y && y> part.partCoordinates.y - part.partData.gridSize.y)
            return true;
          break;
        case -90:
        if(part.partCoordinates.y == y && x <= part.partCoordinates.x && x > part.partCoordinates.x - part.partData.gridSize.y)
            return true;
          break;
        case 180:
          if(part.partCoordinates.x == x && y >= part.partCoordinates.y && y < part.partCoordinates.y + part.partData.gridSize.y)
            return true;
          break;
        case 90:
        if(part.partCoordinates.y == y && x >= part.partCoordinates.x && x < part.partCoordinates.x + part.partData.gridSize.y)
            return true;
          break;
        default:
          break;
      }
      return false;
}


function maxbackgroundClicked(event)
{
  stage.removeChild(maxTopDownView);
  toolTipText.visible = true;
}

function maxSortElements()
{
  var sortFunction = function(obj1, obj2, options){
    if(obj1.PRIORITY && obj2.PRIORITY && obj1.PRIORITY == obj2.PRIORITY)
      return 0;
    else if ((obj1.PRIORITY && !obj2.PRIORITY) ||(obj1.PRIORITY > obj2.PRIORITY))
      return 1
    else if ((obj2.PRIORITY && !obj1.PRIORITY) ||(obj2.PRIORITY > obj1.PRIORITY))
      return -1;
    else{
      return -1;
    }
  }
  maxTopDownView.sortChildren(sortFunction);
}
