 /* Controllers */
 var scope;
 var showTable;
 var modalInstance;
 var configuratorApp = angular.module('configuratorApp', ['ui.bootstrap']);
 configuratorApp.controller('ConfiguratorCtrl', ['$scope', '$window', '$modal', function($scope, $window, $modal) {
   if(scope == null)
    scope = $scope;

   $scope.openModal = function(){
      modalInstance = $modal.open({
      templateUrl: 'form.html',
      controller: ModalInstanceCtrl,
      scope: $scope,
      dialogClass: 'modal form'
    });
   }

   $scope.closeModal = function(){
      modalInstance.dismiss('cancel');
   }
}]);


 function angularUpdate(parts) {
  var summaryParts = new Array();
  for(var i=0; i< parts.length; i++) {
    var part = partsContainer.getChildByName(parts[i]);
    var found = false;
    for(var j=0; j < summaryParts.length; j++) {
      if (summaryParts[j].sku == part.partData.sku){
        summaryParts[j].quantity++;
        found = true;
        break;
      }
    }
    if(!found){
      summaryParts.push(summaryEntry(part.partData));
    }
  }
  scope.showTable = showTable;
  scope.parts = summaryParts;
  scope.$apply();

 }

 var ModalInstanceCtrl = function ($scope, $modalInstance) {
    $scope.renderPrintView = function(){
      var printWindow = window.open("","MsgWindow","width=960,height=960");
      printWindow.document.write("<link rel='stylesheet' type='text/css' href='css/bootstrap.min.css'><link rel='stylesheet' type='text/css' href='css/style.css'><div class='row'><img style='display: block; margin-left: auto; margin-right: auto' src='assets/UDesignLogo.jpg'></div><BR><div class='container'><h4 align='center'>Components in Configuration</h4><div class='container'><table class='table table-bordered table-responsive'><tr><th>Tri-Arc Part #</th><th>Quantity</th><th>Description</th></tr>");
        for(var i=0;i< scope.parts.length; i++){
          printWindow.document.write("<tr><td>" + scope.parts[i].sku + "</td><td>" + scope.parts[i].quantity + "</td><td>" + scope.parts[i].description + "</td></tr>");
        }
      printWindow.document.write("</table></div></div><div class='row'><div class='col-sm-12'><table class='table table-responsive'><tr><td><img src='assets/TriArcLogo.jpg'></td><td></td><td></td></table></div></div>")
      printWindow.document.write("<img class='config_image' src='" + scope.imageData + "'>")
      printWindow.document.write("<img class='config_image' src='" + scope.overviewImage + "'>")
      printWindow.document.focus();
      printWindow.print();
     };
}

 function summaryEntry(partData){
  var entry = {
    sku: partData.sku,
    price: partData.price,
    gsku: partData.gsku,
    description: partData.description,
    quantity: 1,
    cost: partData.price
  };

  return entry;
}

function exportImage(){
  focusCanvas();
  scope.imageData = stage.toDataURL();
  stage.update();
  if(system != 3)
    stage.addChild(TopDownView(true));
  else
    stage.addChild(MaxTopDownView(true));
  stage.update();
  scope.overviewImage = stage.toDataURL();
  scope.completed = true;
  restoreCanvas();
  if(!VENDOR){
    scope.openModal();
    scope.$apply();
  }
  else {
    var printWindow = window.open("","MsgWindow","width=960,height=960");
      printWindow.document.write("<link rel='stylesheet' type='text/css' href='css/bootstrap.min.css'><link rel='stylesheet' type='text/css' href='css/style.css'><div class='row'><img style='display: block; margin-left: auto; margin-right: auto' src='assets/UDesignLogo.jpg'></div><BR><div class='container'><h4 align='center'>Components in Configuration</h4><div class='container'><table class='table table-bordered table-responsive'><tr><th style='color:red;'>Grainger Stock No.</th><th>Tri-Arc Part #</th><th>Quantity</th><th>Description</th></tr>");
        for(var i=0;i< scope.parts.length; i++){
          printWindow.document.write("<tr><td style='color:red;'>" + scope.parts[i].gsku + "</td><td>" + scope.parts[i].sku + "</td><td>" + scope.parts[i].quantity + "</td><td>" + scope.parts[i].description + "</td></tr>");
        }
      printWindow.document.write("</table></div></div><div class='row'><div class='col-sm-12'><table class='table table-responsive'><tr><td><img src='assets/TriArcLogo.jpg'></td><td></td><td><img style='float:right' src='assets/GraingerLogo.jpg'></td></table></div></div>")
      printWindow.document.write("<img class='config_image' src='" + scope.imageData + "'>")
      printWindow.document.write("<img class='config_image' src='" + scope.overviewImage + "'>")
      printWindow.focus();
      printWindow.print();
    scope.$apply();
  }
}

function submitForm(form){
  form.parts.value = "<table class='table table-bordered table-responsive'><tr><th>Tri-Arc Part #</th><th>Quantity</th><th>Description</th></tr>";
      for(var i=0;i< scope.parts.length; i++){
        form.parts.value += "<tr><td>" + scope.parts[i].sku + "</td><td>" + scope.parts[i].quantity + "</td><td>" + scope.parts[i].description + "</td></tr>";
      }
  form.parts.value +="</table>";
  form.image.value = scope.imageData;
  form.overviewImage.value = scope.overviewImage;
  if(form.name.value.length < 1 || form.company.value.length < 1 || form.email.value.length < 1 || form.phone.value.length < 1)
    return;
  $.ajax({
        url: 'http://tri-arc.com/configurator/mailer.php',
        type:'POST',
        data: {
          name : form.name.value,
          company : form.company.value,
          phone : form.phone.value,
          email : form.email.value,
          parts : form.parts.value,
          comments : form.comments.value,
          referrer : form.referrer.value,
          image: form.image.value,
          overviewImage:form.overviewImage.value
        },
        success: function(msg)
        {
            alert('Email Sent');
        }
        });
}
