// Select Part Menu

var selectPartMenu;
var originalPart;
var lastPartAdded;
function SelectPartMenu(part){
  refreshParts();
  selectPartMenu = new createjs.Container();
  selectPartMenu.originPart = part;
  originalPart = part;
  selectPartMenu.name = "SELECT_PART_MENU";
  if(partsMenuContainer.getChildByName("PART_BUTTONS_CONTAINER"))
  {
    partsMenuContainer.removeChild(partsMenuContainer.getChildByName("PART_BUTTONS_CONTAINER"));
  }

  var partButtonsContainer = new createjs.Container();
  partButtonsContainer.name = "PART_BUTTONS_CONTAINER";
  stage.getChildByName("PARTS_MENU_CONTAINER").addChild(partButtonsContainer);
  addPartButtons(part, partButtonsContainer);
  if (((!part.mountSlotFull || part.partData.rails) || (part.partData.actsAsLegs && !part.partData.turnpiece)) && part.parentPart != null)
    addRemoveButton();

  if(partButtonsContainer.getNumChildren() > 0)
  {
    partsMenuContainerText.text = "Select a part to add";
  }
  else
  {
    partsMenuContainerText.text = "";
  }

  return selectPartMenu;
}

function addRemoveButton(){
  var removeButton = new createjs.Container();
  removeButton.x = 0;
  removeButton.y = 640;
  removeButton.name = "REMOVE_BUTTON";

  partsMenuContainer.addChild(removeButton);

  var removeButtonShape = new createjs.Shape();
  removeButtonShape.graphics.beginFill("#ff9e35").beginStroke("#e17a0f").drawRoundRect(0,0,260,60,5);

  removeButton.addChild(removeButtonShape);

  var removeButtonText = new createjs.Text("Remove Last Part", "20px sans-serif", "#FFF");
  removeButtonText.textAlign = "center";
  removeButtonText.x = 130;
  removeButtonText.y = 20;

  removeButton.addChild(removeButtonText);

  var removeButtonHelper = new createjs.ButtonHelper(removeButton);
  removeButton.addEventListener("click", handleRemoveClicked);
}

function hasLadderAsChild(part){
  for(var i=0; i<partsContainer.getNumChildren(); i++){
      childPart = partsContainer.getChildAt(i);
      if(childPart.parentPart == part && childPart.partData.ladder){
          return true;
      }
    }
  return false;
}

function addPartButtons(part, selectPartMenu){
  var x = y = 0;
  for(var i=0; i < part.partData.connectableParts.length; i++){
    newPart = PARTS[part.partData.connectableParts[i]];

    if((newPart.usesSlot == MOUNT_SLOT && part.mountSlotFull) ||
      (newPart.usesSlot == LEG_SLOT && part.legSlotFull) ||
      (newPart.ladder && (part.legSlotFull && !part.partData.turnPiece)) ||
      (part.mountSlotFull && newPart.legs && hasLadderAsChild(part)))
      continue;

    var partButton = new createjs.Container();
    partButton.part = newPart;
    partButton.x = x*125 + 10;
    partButton.y = y*120 + 20;
    selectPartMenu.addChild(partButton);

    var partButtonShape = new createjs.Shape();
    partButtonShape.graphics.beginFill("#FFF").beginStroke("#e17a0f").drawRoundRect(0,0,100,90,5);
    partButton.addChild(partButtonShape);

    var partButtonText = new createjs.Text(newPart.name, "12px sans-serif", "#444");
    partButtonText.textAlign = "center";
    partButtonText.x = 50;
    partButtonText.y = 92;
    partButton.addChild(partButtonText);

    var partImg = new createjs.Sprite(newPart.spriteSheet);
    partImg.gotoAndStop((part.currentFrame + part.partData.childFrameOffset + newPart.frameOffset % 4));
    partImg.regX = newPart.spriteCenter.x;
    partImg.regY = newPart.spriteCenter.y;
    partImg.scaleX = partImg.scaleY = 0.2;
    partImg.x = 50;
    partImg.y = 35;
    partButton.addChild(partImg);

    selectPartMenu.addChild(partButton);

    var partButtonHelper = new createjs.ButtonHelper(partButton);
    partButton.addEventListener("click", handlePartSelected);

    x++;
    if (x == 2){
      x = 0;
      y++;
    }
  }
}

// Event Handlers

function handleRemoveClicked(event){
  if(selectPartMenu.originPart.legSlotFull){
    for(var i=0; i<partsContainer.getNumChildren(); i++){
      part = partsContainer.getChildAt(i);
      if(part.parentPart == selectPartMenu.originPart){
        parts.splice(parts.indexOf(part.name), 1);
        partsContainer.removeChild(part);
        break;
      }
    }
  }
  var parent = selectPartMenu.originPart.parentPart;
    selectPartMenu.originPart.parentPart.mountSlotFull = false;
    partsContainer.removeChild(partsContainer.getChildByName(selectPartMenu.originPart.name));
    parts.splice(parts.indexOf(selectPartMenu.originPart.name), 1);
    SelectPartMenu(parent);
    partsMenuContainerText.text = "Select a part to add";
    partsMenuContainer.removeChild(partsMenuContainer.getChildByName("REMOVE_BUTTON"));
    updateZOrder();
    angularUpdate(parts);
}

function handlePartSelected(event){
  newPart = (Part(event.target.parent.part, selectPartMenu.originPart));
  partsContainer.addChild(newPart);
  if(!newPart.partData.legs)
    newPart.iZOrderMod = partsContainer.getChildByName(newPart.name).y;
  else
    newPart.iZOrderMod += partsContainer.getChildByName(newPart.name).y;
  updateZOrder();
  angularUpdate(parts);
}