var topDownView;
var rooftopMessage = "6\" added all around ladder for the rubber feet";
var crossoverMessage = "FOR ADDED STABILITY OUTRIGGERS HAVE BEEN ADDED \n(ADD 29\" ON EACH SIDE OF 90\xB0 LADDERS)";
function TopDownView(printView)
{
  if(!printView)
    printView = false;

  topDownView = new createjs.Container();
  topDownViewParts = new createjs.Container();

  var topDownBackgroundShape = new createjs.Shape();
  if(printView)
    topDownBackgroundShape.graphics.beginFill("rgba(40,40,40,1)").drawRect(0,0,960,800);
  else
    topDownBackgroundShape.graphics.beginFill("rgba(40,40,40,0.75").drawRect(0,0,960,800);
  topDownView.addChild(topDownBackgroundShape);

  var topDownBackgroundShapeButtonHelper = new createjs.ButtonHelper(topDownBackgroundShape);
  topDownBackgroundShape.addEventListener("click", backgroundClicked);

  //The Grid
  for(var x=0; x<=960; x+=9)
  {
    var line = new createjs.Shape();
    line.graphics.beginStroke("rgba(255,255,255,0.2)");
    line.graphics.moveTo(x,0);
    line.graphics.lineTo(x, 800);
    topDownViewParts.addChild(line);
  }
  for(var y=0; y<=stage.canvas.height; y+=9)
  {
    var line = new createjs.Shape();
    line.graphics.beginStroke("rgba(255,255,255,0.2)");
    line.graphics.moveTo(0,y);
    line.graphics.lineTo(stage.canvas.width, y);
    topDownViewParts.addChild(line);
  }
  topDownView.addChild(topDownViewParts);

  //Key
  var keyText = new createjs.Text("KEY", "16px sans-serif", "#FFFFFF");
  keyText.textAlign = "center";
  keyText.x = 880;
  keyText.y = 10;
  topDownView.addChild(keyText);

  var ladderShape = new createjs.Shape();
  ladderShape.x = 790;
  ladderShape.y = 30;
  ladderShape.graphics.beginFill("rgba(255,192,0,0.75)").beginStroke("#000000").drawRect(0,0,15,15);
  topDownView.addChild(ladderShape);

  var ladderText = new createjs.Text("LADDER", "16px sans-serif", "#FFFFFF");
  ladderText.textAlign = "left";
  ladderText.y = 30;
  ladderText.x = 815;
  topDownView.addChild(ladderText);

  var spanShape = new createjs.Shape();
  spanShape.x = 790;
  spanShape.y = 50;
  spanShape.graphics.beginFill("rgba(192,192,192,0.75)").beginStroke("#000000").drawRect(0,0,15,15);
  topDownView.addChild(spanShape);

  var spanText = new createjs.Text("BRIDGE SPAN", "16px sans-serif", "#FFFFFF");
  spanText.textAlign = "left";
  spanText.y = 50;
  spanText.x = 815;
  topDownView.addChild(spanText);

  var turnShape = new createjs.Shape();
  turnShape.x = 790;
  turnShape.y = 70;
  turnShape.graphics.beginFill("rgba(64,192,255,0.75)").beginStroke("#000000").drawRect(0,0,15,15);
  topDownView.addChild(turnShape);

  var turnText = new createjs.Text("TURN PLATFORM", "16px sans-serif", "#FFFFFF");
  turnText.textAlign = "left";
  turnText.y = 70;
  turnText.x = 815;
  topDownView.addChild(turnText);

  var totalSpanShape = new createjs.Shape();
  totalSpanShape.graphics.beginStroke("#FFFFFF").setStrokeStyle(2,2);
  totalSpanShape.graphics.moveTo(797, 90);
  totalSpanShape.graphics.lineTo(797, 105);
  topDownView.addChild(totalSpanShape);

  var totalSpanText = new createjs.Text("TOTAL LENGTH", "16px sans-serif", "#FFFFFF");
  totalSpanText.y = 90;
  totalSpanText.x = 815;
  topDownView.addChild(totalSpanText);

  var openSpanShape = new createjs.Shape();
  openSpanShape.graphics.beginStroke("#00FF00").setStrokeStyle(2,2);
  openSpanShape.graphics.moveTo(797, 110);
  openSpanShape.graphics.lineTo(797, 125);
  topDownView.addChild(openSpanShape);

  var openSpanText = new createjs.Text("OPEN LENGTH", "16px sans-serif", "#FFFFFF");
  openSpanText.y = 110;
  openSpanText.x = 815;
  topDownView.addChild(openSpanText);

  var legsShape = new createjs.Shape();
  legsShape.graphics.beginStroke("#FF2020").setStrokeStyle(2,2);
  legsShape.graphics.moveTo(797, 130);
  legsShape.graphics.lineTo(797, 145);
  topDownView.addChild(legsShape);

  var legsText = new createjs.Text("LEG KIT", "16px sans-serif", "#FFFFFF");
  legsText.y = 130;
  legsText.x = 815;
  topDownView.addChild(legsText);

  if(!printView)
  {
    var instructionText = new createjs.Text("Click Anywhere to Close", "16px sans-serif", "#FFFFFF");
    instructionText.textAlign = "center";
    instructionText.x = 480;
    instructionText.y = 760;
    topDownView.addChild(instructionText);
  }

  var scaleText = new createjs.Text("Each grid line represents 1\'", "16px sans-serif", "#FFFFFF");
  scaleText.textAlign = "left";
  scaleText.x = 10;
  scaleText.y = 10;
  topDownView.addChild(scaleText);
  if(system == 1 || height > 59)
  {
    var msg = system == 1 ? rooftopMessage : crossoverMessage;
    var messageText = new createjs.Text(msg, "26px sans-serif", "#FFFFFF");
    messageText.textAlign = "left";
    messageText.x = 10;
    messageText.y = 40;
    topDownView.addChild(messageText);
  }
  var point = new createjs.Point(477,414);
  var direction = 0;
  defaultPartsOrder();
  var lastPart;
  var lastContainer;
  var openSpan = 0;
  var openSpanComponents = new Array();
  var length = 0;
  var startPoint = point;
  var directionChange = false;
  for(var i=0; i<partsContainer.getNumChildren(); i++)
  {
    part = partsContainer.getChildAt(i);
    if (part.partData.rails)
      continue;
    if(!part.partData.bridgeSpan && openSpanComponents.length >0){
      var openSpanLine = new createjs.Shape();
      openSpanLine.graphics.beginStroke("#00FF00").setStrokeStyle(2,2);
      openSpanLine.graphics.moveTo(openSpanComponents[0].x, openSpanComponents[0].y);
      openSpanLine.graphics.lineTo(point.x, point.y);
      openSpanLine.PRIORITY = 1;
      topDownViewParts.addChild(openSpanLine);
      
      var openSpanLineText = new createjs.Text(Math.floor(openSpan/12) +"\' " +openSpan%12 +"\"", "10px sans-serif", "#00FF00");
      var midIndex = Math.floor(openSpanComponents.length / 2);
      console.log("Mid: " + midIndex)
      console.log(openSpanComponents)
      switch(direction){
        case 0:
          openSpanLineText.x = openSpanComponents[midIndex].x - 30;
          openSpanLineText.y = openSpanComponents[midIndex].y - 30;
          break;
        case 1:
          openSpanLineText.x = openSpanComponents[midIndex].x - 30;
          openSpanLineText.y = openSpanComponents[midIndex].y + 15;
          break;
        case 2:
          openSpanLineText.x = openSpanComponents[midIndex].x + 15;
          openSpanLineText.y = openSpanComponents[midIndex].y;
          break;
        case 3:
          openSpanLineText.x = openSpanComponents[midIndex].x - 30;
          openSpanLineText.y = openSpanComponents[midIndex].y + 30;
          break; 
        default:
          break; 
      }
      openSpanLineText.PRIORITY = 1;
      topDownViewParts.addChild(openSpanLineText);
      openSpan = 0;
      openSpanComponents = new Array();
    }
    if (part.partData.legs){
      var legShape = new createjs.Shape();
      legShape.graphics.beginFill("#FF2020").beginStroke("#FF2020").setStrokeStyle(2,2);
      legShape.PRIORITY = 2;
      legShape.graphics.drawRect(-((0.75 * part.partData.width)/2), -3, (0.75 * part.partData.width), 3);
      switch(direction){
        case 0:
          legShape.rotation = 0;
          legShape.x = point.x;
          legShape.y = point.y;
          break;
        case 1:
          legShape.rotation = -90;
          legShape.x = point.x;
          legShape.y = point.y;
          break;
        case 2:
          legShape.rotation = -180;
          legShape.x = point.x;
          legShape.y = point.y;
          break;
        case 3:
          legShape.rotation = -270;
          legShape.x = point.x;
          legShape.y = point.y;
          break;
        default:
          break; 
      }
      topDownViewParts.addChild(legShape);
      continue;
    }
    var container = new createjs.Container();
    var rect = new createjs.Shape();
    rect.graphics.beginFill(fillColor(part.partData)).beginStroke("#000000").drawRect(-((0.75 * part.partData.width)/2), 0, (0.75 * part.partData.width), -(0.75 * part.partData.length));
    container.addChild(rect);
    var forwardPoint = new createjs.Shape();
    forwardPoint.x = 0;
    forwardPoint.y = -0.75*part.partData.length;
    forwardPoint.name = "FORWARD";
    container.addChild(forwardPoint);
    var leftPoint = new createjs.Shape();
    leftPoint.x = -0.75*0.5*part.partData.width;
    leftPoint.y = -0.75*part.partData.length*0.5;
    leftPoint.name = "LEFT";
    container.addChild(leftPoint);
    var rightPoint = new createjs.Shape();
    rightPoint.x = 0.75*0.5*part.partData.width;
    rightPoint.y = -0.75*part.partData.length*0.5;
    rightPoint.name = "RIGHT";
    container.addChild(rightPoint);
    switch (direction)
    {
      case 0:
        container.x = point.x;
        container.y = point.y;
        break;
      case 1:
        container.rotation = -90;
        container.x = point.x;
        container.y = point.y;
        break;
      case 2:
        container.rotation = -180;
        container.x = point.x;
        container.y = point.y;
        break;
      case 3:
        container.rotation = -270;
        container.x = point.x;
        container.y = point.y;
        break;
      default:
        break;
    }
    length += part.partData.length;
    var oldDir = direction;
    direction += part.partData.childFrameOffset;
    direction = direction % 4;
    if(part.partData.bridgeSpan){
      openSpanComponents.push(container);
      openSpan += part.partData.length;
    }
    if(part == partsContainer.getChildAt(0))
    {
      var spoint = new createjs.Point(477,414);
      var spanText2 = new createjs.Text(Math.floor(part.partData.width/12) +"\' " +part.partData.width%12 +"\"", "10px sans-serif", "#FFFFFF");
      spanText2.PRIORITY = 1;
      var spanLine2 = new createjs.Shape();
      spanLine2.PRIORITY = 1;
      spanLine2.graphics.beginStroke("#FFFFFF").setStrokeStyle(2,2);
      spanLine2.graphics.moveTo(point.x-part.partData.width*0.375, spoint.y);
      spanLine2.graphics.lineTo(point.x+part.partData.width*0.375, spoint.y);
      spanText2.x = spoint.x;
      spanText2.y = spoint.y - 15;
      topDownViewParts.addChild(spanLine2);
      topDownViewParts.addChild(spanText2);
    }
    if(oldDir != direction){
      directionChange = true;
      var spanText = new createjs.Text(Math.floor(length/12) +"\' " +length%12 +"\"", "10px sans-serif", "#FFFFFF");
      spanText.PRIORITY = 1;
      var spanLine = new createjs.Shape();
      spanLine.PRIORITY = 1;
      spanLine.graphics.beginStroke("#FFFFFF").setStrokeStyle(2,2);
      console.log(direction);
      switch(direction){
        case 0:
          if(oldDir == 3)
          {
            spanText.textAlign = "left";
            spanText.x = point.x - (0.75*length/2);
            spanText.y = point.y + 25;
            spanLine.graphics.moveTo(startPoint.x, startPoint.y);
            spanLine.graphics.lineTo(point.x+(0.75*part.partData.length), point.y);
            spanLine.y += 20;
            length = part.partData.width;
            point = new createjs.Point(container.x-container.getChildByName("LEFT").x, container.y+container.getChildByName("LEFT").y);
            startPoint.x = point.x;
            startPoint.y = point.y;
            startPoint.y += (0.75*part.partData.width);
          }
          else
          {
            spanText.textAlign = "right";
            spanText.x = point.x + (0.75*length/2);
            spanText.y = point.y + 30;
            spanLine.graphics.moveTo(startPoint.x, startPoint.y);
            spanLine.graphics.lineTo(point.x-(0.75*part.partData.length), point.y);
            length = part.partData.width;
            point = new createjs.Point(container.x-container.getChildByName("RIGHT").x, container.y + container.getChildByName("RIGHT").y);
            startPoint.x = point.x;
            startPoint.y = point.y;
            startPoint.y += (0.75*part.partData.width);
            spanLine.y += 25;
          }
          break;
        case 1:
          if(oldDir == 0)
          {
            spanText.textAlign = "left";
            spanText.x = point.x + 25;
            spanText.y = point.y + (0.75*length/4);
            spanLine.graphics.moveTo(startPoint.x, startPoint.y);
            spanLine.graphics.lineTo(point.x, point.y-(0.75*part.partData.length));
            spanLine.x += 22;
            length = part.partData.width;
            point = new createjs.Point(container.x+container.getChildByName("LEFT").x, container.y+container.getChildByName("LEFT").y);
            startPoint.x = point.x;
            startPoint.y = point.y;
            startPoint.x += (0.75*part.partData.width);

          }
          else
          {
            spanText.textAlign = "left";
            spanText.x = point.x + 25;
            spanText.y = point.y - (0.75*length/4);
            spanLine.graphics.moveTo(startPoint.x, startPoint.y);
            spanLine.graphics.lineTo(point.x, point.y + (0.75*part.partData.length));
            length = part.partData.width;
            point = new createjs.Point(container.x-container.getChildByName("RIGHT").x, container.y - container.getChildByName("RIGHT").y);
            startPoint.x = point.x;
            startPoint.y = point.y;
            spanLine.x += 20;
            startPoint.x += (0.75*part.partData.width);
          }
          break;
        case 2:
          if(oldDir == 1)
          {
            spanText.textAlign = "left";
            spanText.x = point.x + (0.75*length/4)
            spanText.y = point.y - 35; 
            spanLine.graphics.moveTo(startPoint.x, startPoint.y);
            spanLine.graphics.lineTo(point.x-(0.75*part.partData.length), point.y);
            length = part.partData.width;
            spanLine.y -= 22;
            point = new createjs.Point(container.x+container.getChildByName("LEFT").x, container.y-container.getChildByName("LEFT").y);
            startPoint.x = point.x;
            startPoint.y = point.y;
            startPoint.y -= (0.75*part.partData.width);
          }
          else
          {
            spanText.textAlign = "left";
            spanText.x = point.x - (0.75*length/4);
            spanText.y = point.y - 30; 
            spanLine.graphics.moveTo(startPoint.x, startPoint.y);
            spanLine.graphics.lineTo(point.x, point.y);
            length = part.partData.width;
            point = new createjs.Point(container.x+container.getChildByName("RIGHT").x, container.y - container.getChildByName("RIGHT").y);
            startPoint.x = point.x;
            startPoint.y = point.y;
          }
          break;
        case 3:
          if(oldDir == 2)
          {
            spanText.textAlign = "right";
            spanText.x = point.x -25;
            spanText.y = point.y  - (0.75*length/4);
            spanLine.graphics.moveTo(startPoint.x, startPoint.y);
            spanLine.graphics.lineTo(point.x, point.y + (0.75*part.partData.width));
            spanLine.x -= 20;
            length = part.partData.width;
            point = new createjs.Point(container.x-container.getChildByName("LEFT").x, container.y-container.getChildByName("LEFT").y);
            startPoint.x = point.x;
            startPoint.y = point.y;
            startPoint.x -= (0.75*part.partData.width);
          }
          else
          {
            spanText.textAlign = "right";
            spanText.x = point.x - 25;
            spanText.y = point.y + (0.75*length/4);
            spanLine.graphics.moveTo(startPoint.x, startPoint.y);
            spanLine.graphics.lineTo(point.x, point.y-(0.75*part.partData.width));
            spanLine.x -= 20;
            length = part.partData.width;
            point = new createjs.Point(container.x+container.getChildByName("RIGHT").x, container.y + container.getChildByName("RIGHT").y);
            startPoint.x = point.x;
            startPoint.y = point.y;
            startPoint.x -=(0.75*part.partData.width);
          }
          break;
        default:
          break;
      }
      topDownViewParts.addChild(spanLine);
      topDownViewParts.addChild(spanText);
    }
    else{
      switch(direction){
        case 0:
          point = new createjs.Point(point.x, point.y - (0.75 * part.partData.length));
          break;
        case 1:
          point = new createjs.Point(point.x - (0.75 * part.partData.length),point.y);
          break
        case 2:
          point = new createjs.Point(point.x, point.y + (0.75 * part.partData.length));
          break;
        case 3:
          point = new createjs.Point(point.x + (0.75 * part.partData.length),point.y);
        default:
          break;
        }
    }
    topDownViewParts.addChild(container);
    lastPart = part;
    lastContainer = container;
  }
  if(length > 0)
  {
    var spanText = new createjs.Text(Math.floor(length/12) +"\' " +length%12 +"\"", "10px sans-serif", "#FFFFFF");
    spanText.PRIORITY = 1;
    var spanLine = new createjs.Shape();
    spanLine.PRIORITY = 1;
    spanLine.graphics.beginStroke("#FFFFFF").setStrokeStyle(2,2);
    spanLine.graphics.moveTo(startPoint.x, startPoint.y);
    spanLine.graphics.lineTo(point.x, point.y);
    switch(system)
    {
      case 1:
        switch(direction)
        {
          case 0:
            spanText.textAlign = "left";
            spanText.x = point.x + (lastPart.partData.width );
            spanText.y = point.y;
            spanLine.x += (0.75 * lastPart.partData.width);
            break;
          case 1:
            spanText.textAlign = "left";
            spanText.x = point.x;
            spanText.y = point.y - (lastPart.partData.width ) - 5; 
            spanLine.y -= (0.75 * lastPart.partData.width);
            break;
          case 2:
            spanText.textAlign = "right";
            spanText.x = point.x - 30;
            spanText.y = point.y - (0.75 * length )/4;
            spanLine.x -= (0.75 * lastPart.partData.width);
            break;
          case 3:
            spanText.textAlign = "left";
            spanText.x = point.x;
            spanText.y = point.y + (lastPart.partData.width );
            spanLine.y += (0.75 * lastPart.partData.width);
            break;
          default:
            break;
        }
        if (part == partsContainer.getChildAt(partsContainer.getNumChildren()-1))
        {
          var spanText2 = new createjs.Text(Math.floor(lastPart.partData.width/12) +"\' " +lastPart.partData.width%12 +"\"", "10px sans-serif", "#FFFFFF");
          spanText2.PRIORITY = 1;
          var spanLine2 = new createjs.Shape();
          spanLine2.PRIORITY = 1;
          spanLine2.graphics.beginStroke("#FFFFFF").setStrokeStyle(2,2);
          if(direction == 2 || direction == 0)
          {
            spanLine2.graphics.moveTo(point.x-15, point.y);
            spanLine2.graphics.lineTo(point.x+15, point.y);
            spanText2.x = point.x;
            spanText2.y = point.y - 15;
          }
          else
          {
            spanLine2.graphics.moveTo(point.x, point.y-15);
            spanLine2.graphics.lineTo(point.x, point.y+15);
            spanText2.x = point.x + 15;
            spanText2.y = point.y;
          }
          topDownViewParts.addChild(spanLine2);
          topDownViewParts.addChild(spanText2);
        }
        break;
      case 2:
        switch(direction)
        {
          case 0:
            spanText.textAlign = "left";
            spanText.x = point.x + (lastPart.partData.width );
            spanText.y = point.y;
            spanLine.x += 3*lastPart.partData.width/4;
            break;
          case 1:
            spanText.textAlign = "left";
            spanText.x = point.x - (0.75 * length )/4;
            spanText.y = point.y - (5*lastPart.partData.width/4 ); 
            spanLine.y -= (3*lastPart.partData.width/4 );
            break;
          case 2:
            spanText.textAlign = "right";
            spanText.x = point.x ;
            spanText.y = point.y;
            spanLine.x -= 3*lastPart.partData.width/4;
            break;
          case 3:
            spanText.textAlign = "left";
            spanText.x = point.x;
            spanText.y = point.y + (5*lastPart.partData.width/4 );
            spanLine.y += (3*lastPart.partData.width/4);
            break;
          default:
            break;
        }
        if (!directionChange)
        {
          var spanText2 = new createjs.Text(Math.floor(30/12) +"\' " +30%12 +"\"", "10px sans-serif", "#FFFFFF");
          spanText2.PRIORITY = 1;
          var spanLine2 = new createjs.Shape();
          spanLine2.PRIORITY = 1;
          spanLine2.graphics.beginStroke("#FFFFFF").setStrokeStyle(2,2);
          if(direction == 2 || direction == 0)
          {
            spanLine2.graphics.moveTo(point.x-11.25, point.y);
            spanLine2.graphics.lineTo(point.x+11.25, point.y);
            spanText2.x = point.x;
            spanText2.y = point.y - 15;
          }
          else
          {
            spanLine2.graphics.moveTo(point.x, point.y-11.25);
            spanLine2.graphics.lineTo(point.x, point.y+11.25);
            spanText2.x = point.x + 15;
            spanText2.y = point.y;
          }
        }
        topDownViewParts.addChild(spanLine2);
        topDownViewParts.addChild(spanText2);
        break;
      default:
        break;
    }
    topDownViewParts.addChild(spanLine);
    topDownViewParts.addChild(spanText);
  }
  updateZOrder();
  sortElements();
  topDownViewParts.scaleX = topDownViewParts.scaleY = 2.5;
  topDownViewParts.x = -500;
  topDownViewParts.y = -300;
  return topDownView;
}

function fillColor(data)
{
  if(data.ladder)
    return "rgba(255,192,64,0.75)"
  else if (data.turnPiece)
    return "rgba(64,192,255,0.75)"
  else
    return "rgba(192,192,192,0.75)"
}


function backgroundClicked(event)
{
  stage.removeChild(topDownView);
}

function sortElements()
{
  var sortFunction = function(obj1, obj2, options){
    if(obj1.PRIORITY && obj2.PRIORITY && obj1.PRIORITY == obj2.PRIORITY)
      return 0;
    else if ((obj1.PRIORITY && !obj2.PRIORITY) ||(obj1.PRIORITY > obj2.PRIORITY))
      return 1
    else if ((obj2.PRIORITY && !obj1.PRIORITY) ||(obj2.PRIORITY > obj1.PRIORITY))
      return -1;
    else{
      return -1;
    }
  }
  topDownViewParts.sortChildren(sortFunction);
}