var stage;

// Enums
var LadderType = { 
  Rooftop:1, 
  Crossover:2,
  MaxAccess:3
}

var TreadType = {
  Perforated:1,
  Grip:2,
}

// Flags
var system;
var height;
var incline;
var tread;

function init() {
  if (document.getElementById("configuratorCanvas").addEventListener) {
      document.getElementById("configuratorCanvas").addEventListener("mousewheel", MouseWheelHandler(), false);
      document.getElementById("configuratorCanvas").addEventListener("DOMMouseScroll", MouseWheelHandler(), false);
  } else {
      sq.attachEvent("onmousewheel", MouseWheelHandler());
  }

    stage = new createjs.Stage("configuratorCanvas");
    createjs.Touch.enable(stage);
    stage.enableMouseOver(50);
    createjs.DisplayObject.suppressCrossDomainErrors = true;
    stage.setBounds(0,0,stage.canvas.width,stage.canvas.height);stage.setBounds(0,0,stage.canvas.width,stage.canvas.height);
    createjs.Ticker.addEventListener("tick", handleTick);
    showStartMenu();
}

function handleTick(event) {
  stage.setBounds(0,0,stage.canvas.width,stage.canvas.height);
  if(system == 3 && showTooltip){
    updateTooltipPosition();
  }
  stage.update();
  angularUpdate(parts);
}


function showStartMenu() {
    stage.removeAllChildren();
    showTable = false;
    scope.showTable = false;
    scope.parts = [];
    scope.$apply();
    startMenu = StartMenu();
    startMenu.x = stage.getBounds().width / 2;
    stage.addChild(startMenu);
}

function showHeightMenu() {
  stage.removeAllChildren();
  switch(system) {
    case 1:
      heightMenu = RT_HeightMenu();
      break;
    case 2:
      heightMenu = CO_HeightMenu();
      break;
    case 3:
      heightMenu = MA_HeightMenu();
      break;
    default: 
      break;
  }
  heightMenu.x = stage.getBounds().width / 2;
  stage.addChild(heightMenu);
}

function showSystemOptionsMenu(){
  switch(system){
    case 1:
      showInclineMenu();
      break;
    case 2:
      showPlatformTypeMenu();
      break;
    case 3:
      showInclineMenu();
      break;
    default:
      showInclineMenu();
      break;
  }
}

function showInclineMenu() {
  stage.removeAllChildren();

  inclineMenu = InclineMenu(system != LadderType.Crossover);

  inclineMenu.x = stage.getBounds().width / 2;
  stage.addChild(inclineMenu);
}

function showPlatformSizeMenu() {
  stage.removeAllChildren();
  platformSizeMenu = PlatformSizeMenu();

  platformSizeMenu.x = stage.getBounds().width / 2;
  stage.addChild(platformSizeMenu);
}

function showPlatformTypeMenu() {
  stage.removeAllChildren();
  platformTypeMenu = PlatformTypeMenu();

  platformTypeMenu.x = stage.getBounds().width / 2;
  stage.addChild(platformTypeMenu);
}


function showConfigurator(){
  stage.removeAllChildren();
  stage.addChild(ConfiguratorContainer());
  parts.length = 0;
  length = new Array();
  width = new Array();
  iwidth = 0;
  showTable = true;

  showConfiguratorButtons();
  switch(system){
    case 1:
      partsContainer.addChild(InitialPart(LADDER(), null));
      break;
    case 2:
        partsContainer.addChild(InitialPart(LADDER(), null));
      break;
    case 3:
        partsContainer.addChild(InitialMaxPart(LADDER()));
      break;
    default:
      break;
  }
}

function showSummary(){
  stage.addChild(SummaryMenu());
}

function setIncline(i) {
  incline = i;
}

function setHeight(h) {
  height = h;
}

function setSystem(s){
  system = s;
}


function MouseWheelHandler() {
    return function (e) {
      if(system == 3){
          var e = window.event || e;
          var delta = Math.max(-1, Math.min(1, (e.wheelDelta || -e.detail)));

          scrollPartsBar(delta);
          return false;
        }
    }
}