var id = 0;

// Part
function Part(data, parent) {
  var container = new createjs.Container();
  if(data.altSkus){
    switch(treadType){
      case(TreadType.Perforated):
        data.sku = data.sku.substr(0, data.sku.length-1) + "6";
        if(data.gSkus)
          data.gsku = data.gSkus[0];
        break;
      case(TreadType.Grip):
        data.sku = data.sku.substr(0, data.sku.length-1) + "2";
        if(data.gSkus)
          data.gsku = data.gSkus[1];
        break;
      default:
        break;
    }
  }
  container.partData = data;
  container.noParent = false;

  container.legSlotFull = !data.hasLegSlot;
  container.mountSlotFull = !data.hasMountSlot;

  if(data.usesSlot == MOUNT_SLOT)
    parent.mountSlotFull = true;
  else if (data.usesSlot == LEG_SLOT){
    parent.legSlotFull = true;
  }

  container.legsNeeded = data.legsNeeded;
  container.legsLimit = data.legsLimit;
  if(parent.legsNeeded && !parent.legSlotFull)
    container.legsLimit = Math.min(parent.legsLimit-container.partData.length, container.legsLimit-container.partData.length);
  if (container.legsLimit <= 10 && !data.actsAsLegs && !parent.legSlotFull) {
    container.legsLimit = data.legsLimit;
    partsContainer.addChild(Part(LEGS(), parent));
    if(data.rails)
      alert("A leg kit was added automatically as it is needed by the rail kit.");
    else
      alert("A leg kit was added automatically as your span is too long to be unsupported.");
  }
  if(parent.legSlotFull)
    resetChildLegCounter(parent)
  
  container.frameOffset = (data.frameOffset + parent.frameOffset + parent.partData.childFrameOffset) % 4;

  if(parent.childFrameOffset != 0)
    container.rotationOffset = (-90 * container.frameOffset);
  else
    container.rotationOffset = 0;
  
  container.partData.childFrameOffset = data.childFrameOffset;
  container.currentFrame = (currentFrame + container.frameOffset) % 4;
 
  container.parentPart = parent;
  container.rotation = container.rotationOffset;

  container.iZOrderMod = data.iZOrderMod[container.currentFrame];
  
  container.x = parent.x + parent.getChildByName("MOUNT").x - container.partData.connectorPoint[container.currentFrame].x;
  container.y = parent.y + parent.getChildByName("MOUNT").y - container.partData.connectorPoint[container.currentFrame].y;

  if(container.rotationOffset < 0) {
    container.x = parent.x + parent.getChildByName("MOUNT").x + container.partData.connectorPoint[container.currentFrame].x + container.partData.rotationOffsets[((container.rotationOffset / -90) + container.currentFrame)%4].x;
    container.y = parent.y + parent.getChildByName("MOUNT").y + container.partData.connectorPoint[container.currentFrame].y + container.partData.rotationOffsets[((container.rotationOffset / -90) + container.currentFrame)%4].y;
  }

  var sprite = new createjs.Sprite(data.spriteSheet);

  var spriteButtonHelper = new createjs.ButtonHelper(sprite);
  sprite.addEventListener("click", handlePartClicked);
  sprite.addEventListener("mouseover", handleMouseOver);
  sprite.addEventListener("mouseout", handleMouseOut);
  sprite.name = container.name = id;
  id++;

  sprite.regX = data.spriteCenter.x;
  sprite.regY = data.spriteCenter.y;

  container.addChild(sprite);

  var center = new createjs.Shape();
  center.name = "CENTER";
  center.graphics.beginFill(null).drawCircle(0,0,5);
  container.addChild(center);

  var f = new createjs.Shape();
  f.name = "MOUNT";
  f.graphics.beginFill(null).drawCircle(0,0,5);
  f.x = container.partData.mountPoint[container.currentFrame].x;
  f.y = container.partData.mountPoint[container.currentFrame].y;
  container.addChild(f);

  var p = new createjs.Shape();
  p.name = "CONNECTOR";
  p.graphics.beginFill(null).drawCircle(0,0,5);
  p.x = container.partData.connectorPoint[container.currentFrame].x;
  p.y = container.partData.connectorPoint[container.currentFrame].y;
  container.addChild(p);

  sprite.gotoAndStop(container.currentFrame);
  sprite.rotation = (-camAngle - container.rotationOffset);
  parts.push(sprite.name);

  updateDimensions(data.width, data.length, container.currentFrame);
  if(!container.partData.legs)
  {
    SelectPartMenu(container);
    selectPartMenu.originPart = container;
  }
  if(data.ladder && data.name.indexOf("90") != -1 && (system == 1 || (system == 2 && height >= 60)))
  {
    showAddedTip();
  }
  return container;
}

function InitialPart(data) {
  var container = new createjs.Container();
  if(data.altSkus){
    switch(treadType){
      case(TreadType.Perforated):
        data.sku = data.sku.substr(0, data.sku.length-1) + "6";
        if(data.gSkus)
          data.gsku = data.gSkus[0];
        break;
      case(TreadType.Grip):
        data.sku = data.sku.substr(0, data.sku.length-1) + "2";
        if(data.gSkus)
          data.gsku = data.gSkus[1];
        break;
      default:
        break;
    }
  }
  container.partData = data;
  container.noParent = true;
  container.frameOffset = 0;
  container.childFrameOffset = data.childFrameOffset;
  container.rotationOffset = 0;
  container.currentFrame = currentFrame;
  container.legSlotFull = !data.hasLegSlot;
  container.mountSlotFull = !data.hasMountSlot;
  container.zOrderMod = data.zOrderMod[container.currentFrame];
  container.iZOrderMod = data.iZOrderMod[container.currentFrame];
  container.legsLimit = data.legsLimit;
  container.legsNeeded = data.legsNeeded;

  container.x = 0;
  container.y = 0;

  var sprite = new createjs.Sprite(data.spriteSheet);

  var spriteButtonHelper = new createjs.ButtonHelper(sprite);
  sprite.addEventListener("click", handlePartClicked);
  sprite.addEventListener("mouseover", handleMouseOver);
  sprite.addEventListener("mouseout", handleMouseOut);
  sprite.name = container.name = id;
  id++;

  sprite.regX = data.spriteCenter.x;
  sprite.regY = data.spriteCenter.y;

  container.addChild(sprite);

  var center = new createjs.Shape();
  center.name = "CENTER";
  center.graphics.beginFill(null).drawCircle(0,0,5);
  container.addChild(center);

  var f = new createjs.Shape();
  f.name = "MOUNT";
  f.graphics.beginFill(null).drawCircle(0,0,5);
  f.x = container.partData.mountPoint[container.currentFrame].x;
  f.y = container.partData.mountPoint[container.currentFrame].y;
  container.addChild(f);

  var p = new createjs.Shape();
  p.name = "CONNECTOR";
  p.graphics.beginFill(null).drawCircle(0,0,5);
  p.x = container.partData.connectorPoint[container.currentFrame].x;
  p.y = container.partData.connectorPoint[container.currentFrame].y;
  container.addChild(p);

  sprite.gotoAndStop(currentFrame);

  parts.push(sprite.name);

  length.push(data.length);
  iwidth = data.width;
  if(!data.legs){
    SelectPartMenu(container);
    SelectPartMenu.originPart = container;
  }
  if(data.ladder && data.name.indexOf("90") != -1 && (system == 1 || (system == 2 && height >= 60)))
  {
    showAddedTip();
  }
  return container;
}

function updateDimensions(pwidth, plength, frame){
  switch(frame){
    case(0):
      length.push(plength);
      if(pwidth > iwidth && width.length == 0)
        iwidth = pwidth;
      return;
    case(1):
      width.push(-plength);
      return;
    case(2):
      length.push(-plength);
      return;
    case(3):
      width.push(plength);
      return;
  }
}

function resetChildLegCounter(parent){
  for(var i=0; i<partsContainer.getNumChildren(); i++){
      childPart = partsContainer.getChildAt(i);
      if(childPart.parentPart == parent && !childPart.legs){
        childPart.legsLimit = childPart.partData.legsLimit;
        if(parent.legsNeeded && !parent.legSlotFull)
          childPart.legsLimit = Math.min(parent.legsLimit-childPart.partData.length, childPart.legsLimit-childPart.partData.length)
        if(!childPart.actsAsLegs)
          resetChildLegCounter(childPart);
        return;
      }
    }
}

// Event Handlers
function handlePartClicked(event){
  //var clicked = partsContainer.getChildByName(event.target.name);
  //if ((!clicked.mountSlotFull || !clicked.legSlotFull|| (!clicked.partData.hasMountSlot&&!clicked.partData.legs)) && !(hasLadderAsChild(clicked)))
  //  stage.addChild(SelectPartMenu(partsContainer.getChildByName(event.target.name)));
  //updateZOrder();
}

function handleMouseOver(event){
  //var target = partsContainer.getChildByName(event.target.name);
  //if ((!target.mountSlotFull || !target.legSlotFull || (!target.partData.hasMountSlot&&!target.partData.legs)) && !(hasLadderAsChild(target)))
  //  target.filters = [new createjs.ColorFilter(0.5,0.5,0.5,1, 192,64,0,0)];
  //target.cache(-target.partData.spriteCenter.x * 8, -target.partData.spriteCenter.y * 8, target.partData.spriteCenter.x * 16, target.partData.spriteCenter.y *16);
}

function handleMouseOut(event){
  //var target = partsContainer.getChildByName(event.target.name);
  //target.filters = [];
  //target.cache(-target.partData.spriteCenter.x * 8, -target.partData.spriteCenter.y * 8, target.partData.spriteCenter.x * 16, target.partData.spriteCenter.y *16);
}
